/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import jnr.posix.POSIX;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketChannel;
import org.jruby.util.ByteList;
import org.jruby.util.JRubyFile;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.NullChannel;
import org.jruby.util.io.PipeException;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class ChannelDescriptor {
    private static final Logger LOG;
    private static final boolean DEBUG = false;
    private Channel channel;
    private int internalFileno;
    private FileDescriptor fileDescriptor;
    private ModeFlags originalModes;
    private AtomicInteger refCounter;
    private InputStream baseInputStream;
    private boolean canBeSeekable = true;
    private boolean isInAppendMode = false;
    private boolean readableChannel;
    private boolean writableChannel;
    private boolean seekableChannel;
    protected static final AtomicInteger internalFilenoIndex;
    private static final Map<Integer, ChannelDescriptor> filenoDescriptorMap;
    private static final Class SEL_CH_IMPL;
    private static final Method SEL_CH_IMPL_GET_FD;
    private static final Class FILE_CHANNEL_IMPL;
    private static final Field FILE_CHANNEL_IMPL_FD;
    private static final Field FILE_DESCRIPTOR_FD;

    private ChannelDescriptor(Channel channel, int fileno2, ModeFlags originalModes, FileDescriptor fileDescriptor, AtomicInteger refCounter, boolean canBeSeekable, boolean isInAppendMode) {
        this.refCounter = refCounter;
        this.channel = channel;
        this.internalFileno = fileno2;
        this.originalModes = originalModes;
        this.fileDescriptor = fileDescriptor;
        this.canBeSeekable = canBeSeekable;
        this.isInAppendMode = isInAppendMode;
        this.readableChannel = channel instanceof ReadableByteChannel;
        this.writableChannel = channel instanceof WritableByteChannel;
        this.seekableChannel = channel instanceof FileChannel;
        ChannelDescriptor.registerDescriptor(this);
    }

    private ChannelDescriptor(Channel channel, int fileno2, ModeFlags originalModes, FileDescriptor fileDescriptor) {
        this(channel, fileno2, originalModes, fileDescriptor, new AtomicInteger(1), true, false);
    }

    public ChannelDescriptor(Channel channel, ModeFlags originalModes, FileDescriptor fileDescriptor) {
        this(channel, ChannelDescriptor.getNewFileno(), originalModes, fileDescriptor, new AtomicInteger(1), true, false);
    }

    public ChannelDescriptor(Channel channel, ModeFlags originalModes, FileDescriptor fileDescriptor, boolean isInAppendMode) {
        this(channel, ChannelDescriptor.getNewFileno(), originalModes, fileDescriptor, new AtomicInteger(1), true, isInAppendMode);
    }

    public ChannelDescriptor(Channel channel, ModeFlags originalModes) {
        this(channel, ChannelDescriptor.getNewFileno(), originalModes, ChannelDescriptor.getDescriptorFromChannel(channel), new AtomicInteger(1), true, false);
    }

    public ChannelDescriptor(InputStream baseInputStream, ModeFlags originalModes, FileDescriptor fileDescriptor) {
        this(Channels.newChannel(baseInputStream), ChannelDescriptor.getNewFileno(), originalModes, fileDescriptor, new AtomicInteger(1), true, false);
        this.baseInputStream = baseInputStream;
    }

    public ChannelDescriptor(InputStream baseInputStream, ModeFlags originalModes) {
        this(Channels.newChannel(baseInputStream), ChannelDescriptor.getNewFileno(), originalModes, new FileDescriptor(), new AtomicInteger(1), true, false);
        this.baseInputStream = baseInputStream;
    }

    public ChannelDescriptor(Channel channel, FileDescriptor fileDescriptor) throws InvalidValueException {
        this(channel, ChannelDescriptor.getModesFromChannel(channel), fileDescriptor);
    }

    @Deprecated
    public ChannelDescriptor(Channel channel, int fileno2, FileDescriptor fileDescriptor) throws InvalidValueException {
        this(channel, ChannelDescriptor.getModesFromChannel(channel), fileDescriptor);
    }

    public ChannelDescriptor(Channel channel) throws InvalidValueException {
        this(channel, ChannelDescriptor.getModesFromChannel(channel), ChannelDescriptor.getDescriptorFromChannel(channel));
    }

    public int getFileno() {
        return this.internalFileno;
    }

    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    public Channel getChannel() {
        return this.channel;
    }

    InputStream getBaseInputStream() {
        return this.baseInputStream;
    }

    public boolean isSeekable() {
        return this.canBeSeekable && this.seekableChannel;
    }

    public void setCanBeSeekable(boolean canBeSeekable) {
        this.canBeSeekable = canBeSeekable;
    }

    public boolean isNull() {
        return this.channel instanceof NullChannel;
    }

    public boolean isWritable() {
        return this.writableChannel;
    }

    public boolean isReadable() {
        return this.readableChannel;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void checkOpen() throws BadDescriptorException {
        if (!this.isOpen()) {
            throw new BadDescriptorException();
        }
    }

    public ModeFlags getOriginalModes() {
        return this.originalModes;
    }

    public void checkNewModes(ModeFlags newModes) throws InvalidValueException {
        if (!newModes.isSubsetOf(this.originalModes)) {
            throw new InvalidValueException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelDescriptor dup() {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            this.refCounter.incrementAndGet();
            int newFileno = ChannelDescriptor.getNewFileno();
            return new ChannelDescriptor(this.channel, newFileno, this.originalModes, this.fileDescriptor, this.refCounter, this.canBeSeekable, this.isInAppendMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelDescriptor dup2(int fileno2) {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            this.refCounter.incrementAndGet();
            return new ChannelDescriptor(this.channel, fileno2, this.originalModes, this.fileDescriptor, this.refCounter, this.canBeSeekable, this.isInAppendMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dup2Into(ChannelDescriptor other) throws BadDescriptorException, IOException {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            this.refCounter.incrementAndGet();
            other.close();
            other.channel = this.channel;
            other.originalModes = this.originalModes;
            other.fileDescriptor = this.fileDescriptor;
            other.refCounter = this.refCounter;
            other.canBeSeekable = this.canBeSeekable;
            other.readableChannel = this.readableChannel;
            other.writableChannel = this.writableChannel;
            other.seekableChannel = this.seekableChannel;
        }
    }

    public ChannelDescriptor reopen(Channel channel, ModeFlags modes) {
        return new ChannelDescriptor(channel, this.internalFileno, modes, this.fileDescriptor);
    }

    public ChannelDescriptor reopen(RandomAccessFile file2, ModeFlags modes) throws IOException {
        return new ChannelDescriptor((Channel)file2.getChannel(), this.internalFileno, modes, file2.getFD());
    }

    public long lseek(long offset2, int whence) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        if (this.seekableChannel) {
            this.checkOpen();
            FileChannel fileChannel = (FileChannel)this.channel;
            try {
                long pos2;
                switch (whence) {
                    case 0: {
                        pos2 = offset2;
                        fileChannel.position(pos2);
                        break;
                    }
                    case 1: {
                        pos2 = fileChannel.position() + offset2;
                        fileChannel.position(pos2);
                        break;
                    }
                    case 2: {
                        pos2 = fileChannel.size() + offset2;
                        fileChannel.position(pos2);
                        break;
                    }
                    default: {
                        throw new InvalidValueException();
                    }
                }
                return pos2;
            }
            catch (IllegalArgumentException e) {
                throw new InvalidValueException();
            }
            catch (IOException ioe) {
                if (ioe.getMessage().equals("Illegal seek")) {
                    throw new PipeException();
                }
                throw ioe;
            }
        }
        throw new PipeException();
    }

    public int read(int number, ByteList byteList) throws IOException, BadDescriptorException {
        this.checkOpen();
        byteList.ensure(byteList.length() + number);
        int bytesRead = this.read(ByteBuffer.wrap(byteList.getUnsafeBytes(), byteList.begin() + byteList.length(), number));
        if (bytesRead > 0) {
            byteList.length(byteList.length() + bytesRead);
        }
        return bytesRead;
    }

    public int read(ByteBuffer buffer) throws IOException, BadDescriptorException {
        this.checkOpen();
        if (!this.isReadable()) {
            throw new BadDescriptorException();
        }
        ReadableByteChannel readChannel = (ReadableByteChannel)this.channel;
        int bytesRead = 0;
        bytesRead = readChannel.read(buffer);
        return bytesRead;
    }

    public int internalWrite(ByteBuffer buffer) throws IOException, BadDescriptorException {
        this.checkOpen();
        if (!this.isWritable()) {
            throw new BadDescriptorException();
        }
        WritableByteChannel writeChannel = (WritableByteChannel)this.channel;
        if (this.isSeekable() && this.originalModes.isAppendable() && !this.isInAppendMode) {
            FileChannel fileChannel = (FileChannel)this.channel;
            fileChannel.position(fileChannel.size());
        }
        return writeChannel.write(buffer);
    }

    public int write(ByteBuffer buffer) throws IOException, BadDescriptorException {
        this.checkOpen();
        return this.internalWrite(buffer);
    }

    public int write(ByteList buf) throws IOException, BadDescriptorException {
        this.checkOpen();
        return this.internalWrite(ByteBuffer.wrap(buf.getUnsafeBytes(), buf.begin(), buf.length()));
    }

    public int write(ByteList buf, int offset2, int len) throws IOException, BadDescriptorException {
        this.checkOpen();
        return this.internalWrite(ByteBuffer.wrap(buf.getUnsafeBytes(), buf.begin() + offset2, len));
    }

    public int write(int c) throws IOException, BadDescriptorException {
        this.checkOpen();
        ByteBuffer buf = ByteBuffer.allocate(1);
        buf.put((byte)c);
        buf.flip();
        return this.internalWrite(buf);
    }

    public static ChannelDescriptor open(String cwd, String path2, ModeFlags flags) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException {
        return ChannelDescriptor.open(cwd, path2, flags, 0, null, null);
    }

    public static ChannelDescriptor open(String cwd, String path2, ModeFlags flags, ClassLoader classLoader) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException {
        return ChannelDescriptor.open(cwd, path2, flags, 0, null, classLoader);
    }

    public static ChannelDescriptor open(String cwd, String path2, ModeFlags flags, int perm, POSIX posix) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException {
        return ChannelDescriptor.open(cwd, path2, flags, perm, posix, null);
    }

    public static ChannelDescriptor open(String cwd, String path2, ModeFlags flags, int perm, POSIX posix, ClassLoader classLoader) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException {
        if (path2.equals("/dev/null") || path2.equalsIgnoreCase("nul:") || path2.equalsIgnoreCase("nul")) {
            NullChannel nullChannel = new NullChannel();
            return new ChannelDescriptor((Channel)nullChannel, flags);
        }
        if (path2.startsWith("classpath:/") && classLoader != null) {
            path2 = path2.substring("classpath:/".length());
            InputStream is = classLoader.getResourceAsStream(path2);
            return new ChannelDescriptor((Channel)Channels.newChannel(is), flags);
        }
        return JRubyFile.createResource(posix, cwd, path2).openDescriptor(flags, perm);
    }

    public void close() throws BadDescriptorException, IOException {
        this.finish(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish(boolean close2) throws BadDescriptorException, IOException {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            int count2;
            if (this.refCounter.get() <= 0) {
                throw new BadDescriptorException();
            }
            if (!this.channel.isOpen()) {
                throw new BadDescriptorException();
            }
            if (close2 && (count2 = this.refCounter.decrementAndGet()) <= 0) {
                try {
                    this.channel.close();
                }
                finally {
                    ChannelDescriptor.unregisterDescriptor(this.internalFileno);
                }
            }
        }
    }

    private static ModeFlags getModesFromChannel(Channel channel) throws InvalidValueException {
        ModeFlags modes = channel instanceof ReadableByteChannel ? (channel instanceof WritableByteChannel ? new ModeFlags(ModeFlags.RDWR) : new ModeFlags(ModeFlags.RDONLY)) : (channel instanceof WritableByteChannel ? new ModeFlags(ModeFlags.WRONLY) : new ModeFlags(ModeFlags.RDWR));
        return modes;
    }

    public static int getNewFileno() {
        return internalFilenoIndex.incrementAndGet();
    }

    private static void registerDescriptor(ChannelDescriptor descriptor) {
        filenoDescriptorMap.put(descriptor.getFileno(), descriptor);
    }

    public static void unregisterDescriptor(int aFileno) {
        filenoDescriptorMap.remove(aFileno);
    }

    public static ChannelDescriptor getDescriptorByFileno(int aFileno) {
        return filenoDescriptorMap.get(aFileno);
    }

    public static Map<Integer, ChannelDescriptor> getFilenoDescriptorMapReadOnly() {
        return Collections.unmodifiableMap(filenoDescriptorMap);
    }

    public static FileDescriptor getDescriptorFromChannel(Channel channel) {
        block11: {
            if (SEL_CH_IMPL_GET_FD != null && SEL_CH_IMPL.isInstance(channel)) {
                try {
                    return (FileDescriptor)SEL_CH_IMPL_GET_FD.invoke((Object)channel, new Object[0]);
                }
                catch (Exception e) {
                    break block11;
                }
            }
            if (FILE_CHANNEL_IMPL_FD != null && FILE_CHANNEL_IMPL.isInstance(channel)) {
                try {
                    return (FileDescriptor)FILE_CHANNEL_IMPL_FD.get(channel);
                }
                catch (Exception e) {
                    break block11;
                }
            }
            if (FILE_DESCRIPTOR_FD != null) {
                FileDescriptor unixFD = new FileDescriptor();
                try {
                    if (channel instanceof UnixSocketChannel) {
                        FILE_DESCRIPTOR_FD.set(unixFD, ((UnixSocketChannel)channel).getFD());
                        return unixFD;
                    }
                    if (channel instanceof UnixServerSocketChannel) {
                        FILE_DESCRIPTOR_FD.set(unixFD, ((UnixServerSocketChannel)channel).getFD());
                        return unixFD;
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return new FileDescriptor();
    }

    static {
        Field ffd;
        Field fd;
        Class<?> fileChannelImpl;
        Method getFD;
        Class<?> selChImpl;
        LOG = LoggerFactory.getLogger("ChannelDescriptor");
        internalFilenoIndex = new AtomicInteger(2);
        filenoDescriptorMap = new ConcurrentHashMap<Integer, ChannelDescriptor>();
        try {
            selChImpl = Class.forName("sun.nio.ch.SelChImpl");
            try {
                getFD = selChImpl.getMethod("getFD", new Class[0]);
                getFD.setAccessible(true);
            }
            catch (Exception e) {
                getFD = null;
            }
        }
        catch (Exception e) {
            selChImpl = null;
            getFD = null;
        }
        SEL_CH_IMPL = selChImpl;
        SEL_CH_IMPL_GET_FD = getFD;
        try {
            fileChannelImpl = Class.forName("sun.nio.ch.FileChannelImpl");
            try {
                fd = fileChannelImpl.getDeclaredField("fd");
                fd.setAccessible(true);
            }
            catch (Exception e) {
                fd = null;
            }
        }
        catch (Exception e) {
            fileChannelImpl = null;
            fd = null;
        }
        FILE_CHANNEL_IMPL = fileChannelImpl;
        FILE_CHANNEL_IMPL_FD = fd;
        try {
            ffd = FileDescriptor.class.getDeclaredField("fd");
            ffd.setAccessible(true);
        }
        catch (Exception e) {
            ffd = null;
        }
        FILE_DESCRIPTOR_FD = ffd;
    }
}

