/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.jsr223.JRubyEngine;
import org.jruby.embed.util.SystemPropertyCatcher;

public class JRubyEngineFactory
implements ScriptEngineFactory {
    private final String engineName;
    private final String engineVersion;
    private final List<String> extensions = Collections.unmodifiableList(Arrays.asList("rb"));
    private final String languageName;
    private String languageVersion = "jruby 1.7.24";
    private final List<String> mimeTypes = Collections.unmodifiableList(Arrays.asList("application/x-ruby"));
    private final List<String> engineIds = Collections.unmodifiableList(Arrays.asList("ruby", "jruby"));
    private Map<String, Object> parameters;

    public JRubyEngineFactory() {
        this.engineName = "JSR 223 JRuby Engine";
        this.engineVersion = "1.7.24";
        this.languageName = "ruby";
    }

    private void initParameters() {
        this.parameters = new HashMap<String, Object>();
        this.parameters.put("javax.script.engine", this.getEngineName());
        this.parameters.put("javax.script.engine_version", this.getEngineVersion());
        this.parameters.put("javax.script.name", this.getEngineName());
        this.parameters.put("javax.script.language", this.getLanguageName());
        this.parameters.put("javax.script.language_version", this.getLanguageVersion());
        this.parameters.put("THREADING", "THREAD-ISOLATED");
    }

    @Override
    public String getEngineName() {
        return this.engineName;
    }

    @Override
    public String getEngineVersion() {
        return this.engineVersion;
    }

    public List getExtensions() {
        return this.extensions;
    }

    @Override
    public String getLanguageName() {
        return this.languageName;
    }

    @Override
    public String getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args2) {
        if (m == null || m.length() == 0) {
            return "";
        }
        if (args2 == null || args2.length == 0) {
            if (obj == null || obj.length() == 0) {
                return MessageFormat.format("{0}", m);
            }
            return MessageFormat.format("{0}.{1}", obj, m);
        }
        StringBuilder builder = new StringBuilder();
        boolean first2 = true;
        for (String arg2 : args2) {
            if (!first2) {
                builder.append(", ");
            }
            first2 = false;
            builder.append(arg2);
        }
        if (obj == null || obj.length() == 0) {
            return MessageFormat.format("{0}({1})", m, builder.toString());
        }
        return MessageFormat.format("{0}.{1}({2})", obj, m, builder.toString());
    }

    public List getMimeTypes() {
        return this.mimeTypes;
    }

    public List getNames() {
        return this.engineIds;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        if (toDisplay == null || toDisplay.length() == 0) {
            return "";
        }
        return "puts " + toDisplay + "\nor\nprint " + toDisplay;
    }

    @Override
    public Object getParameter(String key2) {
        if (this.parameters == null) {
            this.initParameters();
        }
        return this.parameters.get(key2);
    }

    @Override
    public String getProgram(String ... statements) {
        if (statements == null || statements.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String s2 : statements) {
            sb.append(s2);
            sb.append("\n");
        }
        return new String(sb);
    }

    @Override
    public ScriptEngine getScriptEngine() {
        LocalContextScope scope = SystemPropertyCatcher.getScope(LocalContextScope.SINGLETON);
        LocalVariableBehavior behavior = SystemPropertyCatcher.getBehavior(LocalVariableBehavior.GLOBAL);
        boolean lazy = SystemPropertyCatcher.isLazy(false);
        ScriptingContainer container = new ScriptingContainer(scope, behavior, lazy);
        SystemPropertyCatcher.setClassLoader(container);
        SystemPropertyCatcher.setConfiguration(container);
        JRubyEngine engine = new JRubyEngine(container, this);
        return engine;
    }
}

