/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.rss.routing;

import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.TransformerException;
import org.mule.module.rss.routing.EntryLastUpdatedFilter;
import org.mule.module.rss.transformers.ObjectToRssFeed;
import org.mule.routing.AbstractSplitter;

public class FeedSplitter
extends AbstractSplitter {
    public static final String FEED_PROPERTY = "feed.object";
    protected final transient Log logger = LogFactory.getLog(FeedSplitter.class);
    private Filter entryFilter;
    private ObjectToRssFeed objectToFeed = new ObjectToRssFeed();

    public FeedSplitter() {
        this.entryFilter = new EntryLastUpdatedFilter(null);
    }

    protected List<MuleMessage> splitMessage(MuleEvent event) throws MuleException {
        ArrayList<MuleMessage> messages = new ArrayList<MuleMessage>();
        if ((Integer)event.getMessage().getInboundProperty("Content-Length", (Object)-1) == 0) {
            this.logger.info((Object)"Feed has no content, ignoring");
            return messages;
        }
        try {
            SyndFeed feed = this.transformToFeed(event);
            TreeSet<SyndEntry> entries = new TreeSet<SyndEntry>(new EntryComparator());
            entries.addAll(feed.getEntries());
            for (SyndEntry entry : entries) {
                DefaultMuleMessage entryMessage = new DefaultMuleMessage((Object)entry, event.getMuleContext());
                if (this.entryFilter != null && !this.entryFilter.accept((MuleMessage)entryMessage)) continue;
                entryMessage.setInvocationProperty(FEED_PROPERTY, (Object)feed);
                messages.add((MuleMessage)entryMessage);
            }
            return messages;
        }
        catch (MuleException e) {
            throw new MessagingException(e.getI18nMessage(), event, (Throwable)e, (MessageProcessor)this);
        }
    }

    protected SyndFeed transformToFeed(MuleEvent event) throws TransformerException {
        Object payload = event.getMessage().getPayload();
        if (payload instanceof SyndFeed) {
            return (SyndFeed)payload;
        }
        return (SyndFeed)this.objectToFeed.transform(payload);
    }

    public Filter getEntryFilter() {
        return this.entryFilter;
    }

    public void setEntryFilter(Filter entryFilter) {
        this.entryFilter = entryFilter;
    }

    static class EntryComparator
    implements Comparator<SyndEntry> {
        EntryComparator() {
        }

        @Override
        public int compare(SyndEntry e1, SyndEntry e2) {
            if (e1.getPublishedDate().before(e2.getPublishedDate())) {
                return -1;
            }
            if (e1.equals(e2)) {
                return 0;
            }
            return 1;
        }
    }
}

