/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.Validate;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.mule.module.pgp.StreamTransformer;

public class EncryptStreamTransformer
implements StreamTransformer {
    private static final long offset = 0x1000000L;
    private InputStream toBeEncrypted;
    private PGPPublicKey publicKey;
    private Provider provider;
    private OutputStream pgpOutputStream;
    private OutputStream compressedEncryptedOutputStream;
    private OutputStream encryptedOutputStream;
    private OutputStream armoredOut;
    private long bytesWrote;

    public EncryptStreamTransformer(InputStream toBeEncrypted, PGPPublicKey publicKey, Provider provider) throws IOException {
        Validate.notNull((Object)toBeEncrypted, (String)"The toBeEncrypted should not be null");
        Validate.notNull((Object)publicKey, (String)"The publicKey should not be null");
        this.toBeEncrypted = toBeEncrypted;
        this.publicKey = publicKey;
        this.bytesWrote = 0L;
        this.provider = provider;
    }

    @Override
    public void initialize(OutputStream out) throws Exception {
        this.armoredOut = new ArmoredOutputStream(out);
        PGPEncryptedDataGenerator encrDataGen = new PGPEncryptedDataGenerator(3, false, new SecureRandom(), this.provider);
        encrDataGen.addMethod(this.publicKey);
        this.encryptedOutputStream = encrDataGen.open(this.armoredOut, new byte[65536]);
        PGPCompressedDataGenerator comprDataGen = new PGPCompressedDataGenerator(1);
        this.compressedEncryptedOutputStream = comprDataGen.open(this.encryptedOutputStream);
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        this.pgpOutputStream = lData.open(this.compressedEncryptedOutputStream, 'b', "stream", new Date(), new byte[65536]);
    }

    @Override
    public boolean write(OutputStream out, AtomicLong bytesRequested) throws Exception {
        int len = 0;
        byte[] buf = new byte[65536];
        while (bytesRequested.get() + 0x1000000L > this.bytesWrote && (len = this.toBeEncrypted.read(buf)) > 0) {
            this.pgpOutputStream.write(buf, 0, len);
            this.bytesWrote += (long)len;
        }
        if (len <= 0) {
            this.pgpOutputStream.close();
            this.compressedEncryptedOutputStream.close();
            this.encryptedOutputStream.close();
            this.armoredOut.close();
            this.toBeEncrypted.close();
            return true;
        }
        return false;
    }
}

