/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.mule.module.pgp.OutputStreamWriter;

public class DecryptOutputStreamWriter
implements OutputStreamWriter {
    private static final long offset = 0x1000000L;
    private InputStream toBeDecrypted;
    private PGPPublicKey publicKey;
    private PGPSecretKey secretKey;
    private String password;
    private InputStream uncStream;
    private InputStream compressedStream;
    private InputStream clearStream;
    private long bytesWrote;

    public DecryptOutputStreamWriter(InputStream toBeDecrypted, PGPPublicKey publicKey, PGPSecretKey secretKey, String password) throws IOException {
        this.toBeDecrypted = toBeDecrypted;
        this.publicKey = publicKey;
        this.secretKey = secretKey;
        this.password = password;
        this.bytesWrote = 0L;
    }

    public void initialize(OutputStream out) throws Exception {
        InputStream decodedInputStream = PGPUtil.getDecoderStream((InputStream)this.toBeDecrypted);
        PGPObjectFactory pgpF = new PGPObjectFactory(decodedInputStream);
        Object o = pgpF.nextObject();
        if (o == null) {
            throw new IllegalArgumentException("Invalid PGP message");
        }
        PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpF.nextObject();
        Iterator it = enc.getEncryptedDataObjects();
        PGPPublicKeyEncryptedData pbe = null;
        PGPPrivateKey privateKey = null;
        while (privateKey == null && it.hasNext()) {
            pbe = (PGPPublicKeyEncryptedData)it.next();
            privateKey = this.getPrivateKey(pbe.getKeyID(), this.password);
            if (privateKey != null) continue;
            throw new IllegalArgumentException("Failed to find private key with ID " + pbe.getKeyID());
        }
        this.clearStream = pbe.getDataStream(privateKey, "BC");
        PGPObjectFactory plainFact = new PGPObjectFactory(this.clearStream);
        o = plainFact.nextObject();
        PGPOnePassSignature signature = null;
        if (o instanceof PGPOnePassSignatureList) {
            PGPOnePassSignatureList list = (PGPOnePassSignatureList)o;
            signature = list.get(0);
            signature.initVerify(this.publicKey, "BC");
            o = plainFact.nextObject();
        }
        this.compressedStream = null;
        if (o instanceof PGPCompressedData) {
            Object streamData;
            PGPCompressedData cData = (PGPCompressedData)o;
            this.compressedStream = new BufferedInputStream(cData.getDataStream());
            PGPObjectFactory pgpFact = new PGPObjectFactory(this.compressedStream);
            o = streamData = pgpFact.nextObject();
        }
        if (!(o instanceof PGPLiteralData)) {
            throw new PGPException("input is not PGPLiteralData - type unknown.");
        }
        PGPLiteralData ld = (PGPLiteralData)o;
        this.uncStream = ld.getInputStream();
    }

    public boolean write(OutputStream out, AtomicLong bytesRequested) throws Exception {
        int len = 0;
        byte[] buf = new byte[65536];
        boolean wroteSomething = false;
        while (bytesRequested.get() + 0x1000000L > this.bytesWrote && (len = this.uncStream.read(buf)) > 0) {
            out.write(buf, 0, len);
            this.bytesWrote += (long)len;
            wroteSomething = true;
        }
        if (wroteSomething && len <= 0) {
            this.uncStream.close();
            if (this.compressedStream != null) {
                this.compressedStream.close();
            }
            this.clearStream.close();
            return true;
        }
        return false;
    }

    private PGPPrivateKey getPrivateKey(long keyID, String pass) throws PGPException, NoSuchProviderException {
        PGPSecretKey pgpSecKey = this.secretKey;
        if (pgpSecKey == null) {
            return null;
        }
        return pgpSecKey.extractPrivateKey(pass.toCharArray(), "BC");
    }
}

