/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.mule.RequestContext;
import org.mule.api.EncryptionStrategy;
import org.mule.api.MuleEvent;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.CredentialsAccessor;
import org.mule.api.security.CryptoFailureException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.pgp.DecryptOutputStreamWriter;
import org.mule.module.pgp.EncryptOutputStreamWriter;
import org.mule.module.pgp.InvalidPublicKeyException;
import org.mule.module.pgp.LazyInputStream;
import org.mule.module.pgp.PGPCryptInfo;
import org.mule.module.pgp.PGPKeyRing;
import org.mule.module.pgp.i18n.PGPMessages;
import org.mule.security.AbstractNamedEncryptionStrategy;

public class KeyBasedEncryptionStrategy
extends AbstractNamedEncryptionStrategy {
    protected static final Log logger = LogFactory.getLog(KeyBasedEncryptionStrategy.class);
    private PGPKeyRing keyManager;
    private CredentialsAccessor credentialsAccessor;
    private boolean checkKeyExpirity = false;

    public void initialise() throws InitialisationException {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToCreate((String)"KeyBasedEncryptionStrategy"), (Throwable)e, (Initialisable)this);
        }
    }

    public InputStream encrypt(InputStream data, Object cryptInfo) throws CryptoFailureException {
        try {
            PGPCryptInfo pgpCryptInfo = this.safeGetCryptInfo(cryptInfo);
            PGPPublicKey publicKey = pgpCryptInfo.getPublicKey();
            return new LazyInputStream(new EncryptOutputStreamWriter(data, publicKey));
        }
        catch (Exception e) {
            throw new CryptoFailureException((EncryptionStrategy)this, (Throwable)e);
        }
    }

    public InputStream decrypt(InputStream data, Object cryptInfo) throws CryptoFailureException {
        try {
            PGPCryptInfo pgpCryptInfo = this.safeGetCryptInfo(cryptInfo);
            PGPPublicKey publicKey = pgpCryptInfo.getPublicKey();
            return new LazyInputStream(new DecryptOutputStreamWriter(data, publicKey, this.keyManager.getSecretKey(), this.keyManager.getSecretPassphrase()));
        }
        catch (Exception e) {
            throw new CryptoFailureException((EncryptionStrategy)this, (Throwable)e);
        }
    }

    private PGPCryptInfo safeGetCryptInfo(Object cryptInfo) {
        if (cryptInfo == null) {
            MuleEvent event = RequestContext.getEvent();
            PGPPublicKey publicKey = this.keyManager.getPublicKey((String)this.getCredentialsAccessor().getCredentials(event));
            this.checkKeyExpirity(publicKey);
            return new PGPCryptInfo(publicKey, false);
        }
        PGPCryptInfo info = (PGPCryptInfo)cryptInfo;
        this.checkKeyExpirity(info.getPublicKey());
        return info;
    }

    private void checkKeyExpirity(PGPPublicKey publicKey) {
        if (this.isCheckKeyExpirity() && publicKey.getValidDays() != 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(publicKey.getCreationTime());
            calendar.add(5, publicKey.getValidDays());
            if (!calendar.getTime().after(Calendar.getInstance().getTime())) {
                throw new InvalidPublicKeyException(PGPMessages.pgpPublicKeyExpired());
            }
        }
    }

    public PGPKeyRing getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(PGPKeyRing keyManager) {
        this.keyManager = keyManager;
    }

    public CredentialsAccessor getCredentialsAccessor() {
        return this.credentialsAccessor;
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    public boolean isCheckKeyExpirity() {
        return this.checkKeyExpirity;
    }

    public void setCheckKeyExpirity(boolean checkKeyExpirity) {
        this.checkKeyExpirity = checkKeyExpirity;
    }
}

