/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.commons.io.IOUtils;
import org.mule.module.pgp.OutputStreamWriter;

public class LazyInputStream
extends InputStream {
    private PipedInputStream in = new PipedInputStream();
    private PipedOutputStream out = new PipedOutputStream(this.in);
    private AtomicBoolean startedCopying = new AtomicBoolean(false);
    private Thread copyingThread;
    private AtomicLong bytesRequested = new AtomicLong(0L);
    private OutputStreamWriter writer;

    public LazyInputStream(OutputStreamWriter writer) throws IOException {
        this.writer = writer;
    }

    private void copyRequest() {
        if (this.startedCopying.compareAndSet(false, true)) {
            this.copyingThread = new WriteWork();
            this.copyingThread.start();
        }
    }

    public int available() throws IOException {
        this.copyRequest();
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
        this.copyingThread.interrupt();
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        this.bytesRequested.addAndGet(1L);
        this.copyRequest();
        return this.in.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.bytesRequested.addAndGet((long)len);
        this.copyRequest();
        return this.in.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        this.bytesRequested.addAndGet((long)b.length);
        this.copyRequest();
        return this.in.read(b);
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    public long skip(long n) throws IOException {
        this.copyRequest();
        return this.in.skip(n);
    }

    private class WriteWork
    extends Thread {
        private WriteWork() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                LazyInputStream.this.writer.initialize(LazyInputStream.this.out);
                boolean finishWriting = false;
                while (!finishWriting) {
                    finishWriting = LazyInputStream.this.writer.write(LazyInputStream.this.out, LazyInputStream.this.bytesRequested);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)LazyInputStream.this.out);
                while (!this.isInterrupted()) {
                    try {
                        WriteWork.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

