/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.pgp.filters;

import cryptix.message.LiteralMessage;
import cryptix.message.Message;
import cryptix.message.MessageFactory;
import cryptix.message.SignedMessage;
import cryptix.pki.KeyBundle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.extras.pgp.PGPAuthentication;
import org.mule.extras.pgp.PGPCryptInfo;
import org.mule.extras.pgp.PGPKeyRing;
import org.mule.extras.pgp.i18n.PGPMessages;
import org.mule.impl.security.AbstractEndpointSecurityFilter;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.security.UMOAuthentication;
import org.mule.umo.security.UMOEndpointSecurityFilter;
import org.mule.umo.security.UMOSecurityContext;
import org.mule.umo.security.UnauthorisedException;
import org.mule.umo.security.UnknownAuthenticationTypeException;

public class PGPSecurityFilter
extends AbstractEndpointSecurityFilter {
    protected static final Log logger = LogFactory.getLog((Class)PGPSecurityFilter.class);
    private UMOEncryptionStrategy strategy;
    private String strategyName;
    private boolean signRequired;
    private PGPKeyRing keyManager;

    protected void authenticateInbound(UMOEvent event) throws SecurityException, UnauthorisedException, UnknownAuthenticationTypeException {
        UMOAuthentication authResult;
        PGPAuthentication umoAuthentication;
        UMOMessage message = event.getMessage();
        String userId = (String)this.getCredentialsAccessor().getCredentials(event);
        byte[] creds = null;
        try {
            creds = message.getPayloadAsBytes();
            creds = this.strategy.decrypt(creds, null);
        }
        catch (Exception e1) {
            throw new UnauthorisedException(CoreMessages.failedToReadPayload(), event.getMessage(), (Throwable)e1);
        }
        try {
            umoAuthentication = new PGPAuthentication(userId, this.decodeMsgRaw(creds));
        }
        catch (Exception e1) {
            throw new UnauthorisedException(CoreMessages.failedToReadPayload(), event.getMessage(), (Throwable)e1);
        }
        try {
            authResult = this.getSecurityManager().authenticate((UMOAuthentication)umoAuthentication);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication request for user: " + userId + " failed: " + e.toString()));
            }
            throw new UnauthorisedException(CoreMessages.authFailedForUser((Object)userId), event.getMessage(), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authentication success: " + authResult.toString()));
        }
        UMOSecurityContext context = this.getSecurityManager().createSecurityContext(authResult);
        event.getSession().setSecurityContext(context);
        try {
            this.updatePayload(event.getMessage(), this.getUnencryptedMessageWithoutSignature((PGPAuthentication)authResult));
        }
        catch (Exception e2) {
            throw new UnauthorisedException(event.getMessage(), context, event.getEndpoint(), (UMOEndpointSecurityFilter)this);
        }
    }

    private Message decodeMsgRaw(byte[] raw) throws Exception {
        MessageFactory mf = MessageFactory.getInstance((String)"OpenPGP");
        ByteArrayInputStream in = new ByteArrayInputStream(raw);
        Collection msgs = mf.generateMessages((InputStream)in);
        return (Message)msgs.iterator().next();
    }

    private String getUnencryptedMessageWithoutSignature(PGPAuthentication auth) throws Exception {
        Message msg = (Message)auth.getCredentials();
        if (msg instanceof SignedMessage) {
            msg = ((SignedMessage)msg).getContents();
        }
        if (msg instanceof LiteralMessage) {
            return ((LiteralMessage)msg).getTextData();
        }
        throw new Exception("Wrong data");
    }

    protected void authenticateOutbound(UMOEvent event) throws SecurityException, UnauthorisedException {
        logger.debug((Object)("authenticateOutbound:" + event.getId()));
        if (!this.isAuthenticate()) {
            return;
        }
        UMOMessage message = event.getMessage();
        KeyBundle userKeyBundle = this.keyManager.getKeyBundle((String)this.getCredentialsAccessor().getCredentials(event));
        PGPCryptInfo cryptInfo = new PGPCryptInfo(userKeyBundle, this.signRequired);
        try {
            this.updatePayload(event.getMessage(), this.strategy.encrypt(message.getPayloadAsBytes(), (Object)cryptInfo));
        }
        catch (Exception e1) {
            throw new UnauthorisedException(CoreMessages.failedToReadPayload(), event.getMessage(), (Throwable)e1);
        }
    }

    protected void doInitialise() throws InitialisationException {
        if (this.strategyName != null) {
            this.strategy = this.endpoint.getManagementContext().getSecurityManager().getEncryptionStrategy(this.strategyName);
        }
        if (this.strategy == null) {
            throw new InitialisationException(PGPMessages.encryptionStrategyNotSet(), (Initialisable)this);
        }
    }

    public UMOEncryptionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(UMOEncryptionStrategy strategy) {
        this.strategy = strategy;
    }

    public void setStrategyName(String name) {
        this.strategyName = name;
    }

    public boolean isSignRequired() {
        return this.signRequired;
    }

    public void setSignRequired(boolean signRequired) {
        this.signRequired = signRequired;
    }

    public PGPKeyRing getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(PGPKeyRing keyManager) {
        this.keyManager = keyManager;
    }
}

