/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.config.ConfigurationException;
import org.mule.api.routing.filter.Filter;

public class OGNLFilter
implements Filter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile String expression;
    private volatile Object compiledExpression;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) throws ConfigurationException {
        try {
            this.compiledExpression = Ognl.parseExpression((String)expression);
            this.expression = expression;
        }
        catch (OgnlException ex) {
            throw new ConfigurationException((Throwable)ex);
        }
    }

    public boolean accept(MuleMessage message) {
        if (message == null) {
            return false;
        }
        Object candidate = message.getPayload();
        if (candidate == null) {
            return false;
        }
        if (this.compiledExpression == null) {
            this.logger.warn((Object)"No expression configured - rejecting message.");
            return false;
        }
        try {
            Object result = Ognl.getValue((Object)this.compiledExpression, (Object)candidate);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (OgnlException ex) {
            this.logger.error((Object)ex);
        }
        return false;
    }
}

