/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.mbean;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.module.management.mbean.FlowConstructServiceMBean;
import org.mule.module.management.mbean.FlowConstructStats;
import org.mule.module.management.mbean.FlowConstructStatsMBean;

public class FlowConstructService
implements FlowConstructServiceMBean,
MBeanRegistration,
FlowConstructStatsMBean {
    private static Log LOGGER = LogFactory.getLog(FlowConstructService.class);
    protected FlowConstructStatistics statistics;
    protected MBeanServer server;
    protected String name;
    protected String type;
    protected ObjectName statsName;
    protected ObjectName objectName;
    protected MuleContext muleContext;

    public FlowConstructService(String type, String name, MuleContext muleContext, FlowConstructStatistics statistics) {
        this.muleContext = muleContext;
        this.type = type;
        this.name = name;
        this.statistics = statistics;
    }

    protected FlowConstructService(String type, String name, MuleContext muleContext) {
        this.muleContext = muleContext;
        this.type = type;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public ObjectName getStatistics() {
        return this.statsName;
    }

    public void clearStatistics() {
        this.statistics.clear();
    }

    public long getAsyncEventsReceived() {
        return this.statistics.getAsyncEventsReceived();
    }

    public long getSyncEventsReceived() {
        return this.statistics.getSyncEventsReceived();
    }

    public long getTotalEventsReceived() {
        return this.statistics.getTotalEventsReceived();
    }

    public long getAverageProcessingTime() {
        return this.statistics.getAverageProcessingTime();
    }

    public long getProcessedEvents() {
        return this.statistics.getProcessedEvents();
    }

    public long getMaxProcessingTime() {
        return this.statistics.getMaxProcessingTime();
    }

    public long getMinProcessingTime() {
        return this.statistics.getMinProcessingTime();
    }

    public long getTotalProcessingTime() {
        return this.statistics.getTotalProcessingTime();
    }

    public long getExecutionErrors() {
        return this.statistics.getExecutionErrors();
    }

    public long getFatalErrors() {
        return this.statistics.getFatalErrors();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.objectName = name;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        AbstractFlowConstruct flow = (AbstractFlowConstruct)this.muleContext.getRegistry().lookupObject(this.getName());
        try {
            if (flow.getStatistics() != null) {
                this.statsName = new ObjectName(this.objectName.getDomain() + ":type=org.mule.Statistics," + flow.getConstructType() + "=" + this.getName());
                if (this.server.isRegistered(this.statsName)) {
                    this.server.unregisterMBean(this.statsName);
                }
                this.server.registerMBean(new FlowConstructStats(flow.getStatistics()), this.statsName);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error post-registering the MBean", (Throwable)e);
        }
    }

    public void preDeregister() throws Exception {
        try {
            if (this.server.isRegistered(this.statsName)) {
                this.server.unregisterMBean(this.statsName);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error unregistering ServiceService child " + this.statsName.getCanonicalName()), (Throwable)ex);
        }
    }

    public void postDeregister() {
    }
}

