/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.agent;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.util.ArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.AbstractAgent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.management.i18n.ManagementMessages;
import org.mule.module.management.support.AutoDiscoveryJmxSupportFactory;
import org.mule.module.management.support.JmxSupport;
import org.mule.module.management.support.JmxSupportFactory;
import org.tanukisoftware.wrapper.jmx.WrapperManager;
import org.tanukisoftware.wrapper.jmx.WrapperManagerMBean;

public class WrapperManagerAgent
extends AbstractAgent {
    public static final String WRAPPER_OBJECT_NAME = "name=WrapperManager";
    public static final String DEFAULT_WRAPPER_MBEAN_NAME = "org.tanukisoftware.wrapper:type=WrapperManager";
    private static final Log logger = LogFactory.getLog(WrapperManagerAgent.class);
    private static final String WRAPPER_SYSTEM_PROPERTY_NAME = "wrapper.native_library";
    private MBeanServer mBeanServer;
    private ObjectName wrapperName;
    private JmxSupportFactory jmxSupportFactory = AutoDiscoveryJmxSupportFactory.getInstance();
    private JmxSupport jmxSupport = this.jmxSupportFactory.getJmxSupport();
    private final AtomicReference wrapperManagerRef = new AtomicReference();

    public WrapperManagerAgent() {
        super("wrapper-manager");
    }

    public void initialise() throws InitialisationException {
        try {
            boolean launchedByWrapper;
            ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
            if (servers.isEmpty()) {
                throw new InitialisationException(ManagementMessages.noMBeanServerAvailable(), (Initialisable)this);
            }
            this.mBeanServer = (MBeanServer)servers.get(0);
            if (System.getProperty(WRAPPER_SYSTEM_PROPERTY_NAME) == null) {
                launchedByWrapper = false;
            } else {
                if (this.mBeanServer.isRegistered(this.jmxSupport.getObjectName(DEFAULT_WRAPPER_MBEAN_NAME))) {
                    logger.info((Object)"Mule is embedded in a container already launched by a wrapper.Duplicates will not be registered. Use the org.tanukisoftware.wrapper:type=WrapperManager MBean instead for control.");
                    this.unregisterMeQuietly();
                    return;
                }
                this.lazyInitWrapperManager();
                launchedByWrapper = ((WrapperManagerMBean)this.wrapperManagerRef.get()).isControlledByNativeWrapper();
            }
            if (!launchedByWrapper) {
                logger.info((Object)"This JVM hasn't been launched by the wrapper, the agent will not run.");
                this.unregisterMeQuietly();
                return;
            }
            this.wrapperName = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName(this.muleContext) + ":" + WRAPPER_OBJECT_NAME);
            this.unregisterMBeansIfNecessary();
            this.mBeanServer.registerMBean(this.wrapperManagerRef.get(), this.wrapperName);
        }
        catch (InitialisationException iex) {
            throw iex;
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToStart((String)"wrapper agent"), (Throwable)e, (Initialisable)this);
        }
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }

    public void dispose() {
        try {
            this.unregisterMBeansIfNecessary();
        }
        catch (Exception e) {
            logger.error((Object)("Couldn't unregister MBean: " + (this.wrapperName != null ? this.wrapperName.getCanonicalName() : "null")), (Throwable)e);
        }
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public String getDescription() {
        WrapperManagerMBean wm = (WrapperManagerMBean)this.wrapperManagerRef.get();
        if (wm == null) {
            return "Wrapper Manager";
        }
        return "Wrapper Manager: Mule PID #" + wm.getJavaPID() + ", Wrapper PID #" + wm.getWrapperPID();
    }

    protected void lazyInitWrapperManager() {
        WrapperManagerMBean wm = (WrapperManagerMBean)this.wrapperManagerRef.get();
        if (wm != null) {
            return;
        }
        wm = new WrapperManager();
        this.wrapperManagerRef.compareAndSet(null, (Object)wm);
    }

    protected void unregisterMBeansIfNecessary() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        if (this.mBeanServer == null || this.wrapperName == null) {
            return;
        }
        if (this.mBeanServer.isRegistered(this.wrapperName)) {
            this.mBeanServer.unregisterMBean(this.wrapperName);
        }
    }

    protected void unregisterMeQuietly() {
        try {
            this.muleContext.getRegistry().unregisterAgent(this.getName());
        }
        catch (MuleException muleException) {
            // empty catch block
        }
    }
}

