/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.mbeans;

import com.yourkit.api.Controller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.management.mbeans.YourKitProfilerServiceMBean;

public class YourKitProfilerService
implements YourKitProfilerServiceMBean {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private final Controller controller = new Controller();
    private boolean capturing = false;

    public String getHost() {
        return this.controller.getHost();
    }

    public int getPort() {
        return this.controller.getPort();
    }

    public String captureMemorySnapshot() throws Exception {
        return this.controller.captureMemorySnapshot();
    }

    public String captureSnapshot(long snapshotFlags) throws Exception {
        return this.controller.captureSnapshot(snapshotFlags);
    }

    public void startAllocationRecording(long mode) throws Exception {
        this.controller.startAllocationRecording(mode);
    }

    public void stopAllocationRecording() throws Exception {
        this.controller.stopAllocationRecording();
    }

    public void startCPUProfiling(long mode, String filters) throws Exception {
        this.controller.startCPUProfiling(mode, filters);
    }

    public void stopCPUProfiling() throws Exception {
        this.controller.stopCPUProfiling();
    }

    public void startMonitorProfiling() throws Exception {
        this.controller.startMonitorProfiling();
    }

    public void stopMonitorProfiling() throws Exception {
        this.controller.stopMonitorProfiling();
    }

    public void advanceGeneration(String description) {
        this.controller.advanceGeneration(description);
    }

    public long[] forceGC() throws Exception {
        return this.controller.forceGC();
    }

    public void startCapturingMemorySnapshotEverySeconds(final int seconds) {
        if (this.capturing) {
            return;
        }
        this.capturing = true;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    while (YourKitProfilerService.this.capturing) {
                        YourKitProfilerService.this.controller.captureMemorySnapshot();
                        Thread.sleep(seconds * 1000);
                    }
                }
                catch (Exception e) {
                    YourKitProfilerService.this.logger.error((Object)"Failed to capture memory snapshot", (Throwable)e);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void stopCapturingMemorySnapshot() {
        this.capturing = false;
    }

    public long getStatus() throws Exception {
        return this.controller.getStatus();
    }
}

