/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.agents;

import java.util.ArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.management.i18n.ManagementMessages;
import org.mule.management.mbeans.YourKitProfilerService;
import org.mule.management.support.AutoDiscoveryJmxSupportFactory;
import org.mule.management.support.JmxSupport;
import org.mule.management.support.JmxSupportFactory;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.mule.util.ClassUtils;

public class YourKitProfilerAgent
implements UMOAgent {
    public static final String PROFILER_OBJECT_NAME = "name=Profiler";
    private String name = "Profiler Agent";
    private MBeanServer mBeanServer;
    private ObjectName profilerName;
    private JmxSupportFactory jmxSupportFactory = AutoDiscoveryJmxSupportFactory.getInstance();
    private JmxSupport jmxSupport = this.jmxSupportFactory.getJmxSupport();
    protected static final Log logger = LogFactory.getLog((Class)YourKitProfilerAgent.class);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return "Profiler JMX Agent";
    }

    public void initialise() throws InitialisationException {
        if (!this.isApiAvailable()) {
            logger.warn((Object)"Cannot find YourKit API. Profiler JMX Agent will be unregistered.");
            this.unregisterMeQuietly();
            return;
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers.isEmpty()) {
            throw new InitialisationException(ManagementMessages.noMBeanServerAvailable(), (Initialisable)this);
        }
        try {
            this.mBeanServer = (MBeanServer)servers.get(0);
            UMOManagementContext managementContext = MuleServer.getManagementContext();
            this.profilerName = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName(managementContext) + ":" + PROFILER_OBJECT_NAME);
            this.unregisterMBeansIfNecessary();
            this.mBeanServer.registerMBean(new YourKitProfilerService(), this.profilerName);
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToStart((String)this.getName()), (Throwable)e, (Initialisable)this);
        }
    }

    protected void unregisterMBeansIfNecessary() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        if (this.mBeanServer == null || this.profilerName == null) {
            return;
        }
        if (this.mBeanServer.isRegistered(this.profilerName)) {
            this.mBeanServer.unregisterMBean(this.profilerName);
        }
    }

    protected void unregisterMeQuietly() {
        try {
            RegistryContext.getRegistry().unregisterAgent(this.getName());
        }
        catch (UMOException uMOException) {
            // empty catch block
        }
    }

    private boolean isApiAvailable() {
        try {
            ClassUtils.getClass((String)"com.yourkit.api.Controller");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void start() throws UMOException {
    }

    public void stop() throws UMOException {
    }

    public void dispose() {
        try {
            this.unregisterMBeansIfNecessary();
        }
        catch (Exception e) {
            logger.error((Object)("Couldn't unregister MBean: " + (this.profilerName != null ? this.profilerName.getCanonicalName() : "null")), (Throwable)e);
        }
    }

    public void registered() {
    }

    public void unregistered() {
    }
}

