/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.mbeans;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.management.mbeans.StatisticsServiceMBean;
import org.mule.management.stats.AllStatistics;
import org.mule.management.stats.printers.CSVPrinter;
import org.mule.management.stats.printers.HtmlTablePrinter;
import org.mule.management.stats.printers.XMLPrinter;
import org.mule.umo.manager.UMOManager;

public class StatisticsService
implements StatisticsServiceMBean {
    private static final long serialVersionUID = -4949499389883146363L;
    protected static final Log logger = LogFactory.getLog((Class)StatisticsService.class);
    private AllStatistics stats = new AllStatistics();
    private MuleManager manager = null;

    public void setManager(UMOManager manager) {
        this.manager = (MuleManager)manager;
        this.stats = manager == null ? new AllStatistics() : this.manager.getStatistics();
    }

    public void clear() {
        this.stats.clear();
    }

    public boolean isEnabled() {
        return this.stats.isEnabled();
    }

    public void setEnabled(boolean b) {
        this.stats.setEnabled(b);
    }

    public Collection getComponentStatistics() {
        return this.stats.getComponentStatistics();
    }

    public void logSummary() {
        this.stats.logSummary();
    }

    public String printCSVSummary() {
        StringWriter w = new StringWriter(2048);
        CSVPrinter printer = new CSVPrinter((Writer)w);
        printer.setPrintHeaders(true);
        this.stats.logSummary((PrintWriter)printer);
        return w.toString();
    }

    public String printHtmlSummary() {
        StringWriter w = new StringWriter(8192);
        HtmlTablePrinter printer = new HtmlTablePrinter((Writer)w);
        this.stats.logSummary((PrintWriter)printer);
        return w.toString();
    }

    public String printXmlSummary() {
        StringWriter w = new StringWriter(8192);
        XMLPrinter printer = new XMLPrinter((Writer)w);
        this.stats.logSummary((PrintWriter)printer);
        return w.toString();
    }
}

