/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.agents;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.mule.MuleManager;
import org.mule.management.agents.FixedHostRmiClientSocketFactory;
import org.mule.management.agents.JdmkAgent;
import org.mule.management.agents.JmxAgent;
import org.mule.management.agents.JmxServerNotificationAgent;
import org.mule.management.agents.Log4jAgent;
import org.mule.management.agents.Mx4jAgent;
import org.mule.management.agents.RmiRegistryAgent;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.mule.util.StringUtils;

public class DefaultJmxSupportAgent
implements UMOAgent {
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "1099";
    private String name = "Default Jmx";
    private boolean loadJdmkAgent = false;
    private boolean loadMx4jAgent = false;
    private String port;
    private String host;
    private Map credentials = new HashMap();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return "Default Jmx Agent Support";
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public void start() throws UMOException {
    }

    public void stop() throws UMOException {
    }

    public void dispose() {
    }

    public void initialise() throws InitialisationException {
        try {
            Object agent = this.createRmiAgent();
            if (!this.isAgentRegistered((UMOAgent)agent)) {
                MuleManager.getInstance().registerAgent((UMOAgent)agent);
            }
            if (!this.isAgentRegistered((UMOAgent)(agent = this.createJmxAgent()))) {
                MuleManager.getInstance().registerAgent((UMOAgent)agent);
            }
            if (!this.isAgentRegistered((UMOAgent)(agent = this.createLog4jAgent()))) {
                MuleManager.getInstance().registerAgent((UMOAgent)agent);
            }
            if (!this.isAgentRegistered((UMOAgent)(agent = this.createJmxNotificationAgent()))) {
                MuleManager.getInstance().registerAgent((UMOAgent)agent);
            }
            if (this.loadJdmkAgent && !this.isAgentRegistered((UMOAgent)(agent = this.createJdmkAgent()))) {
                MuleManager.getInstance().registerAgent((UMOAgent)agent);
            }
            if (this.loadMx4jAgent && !this.isAgentRegistered((UMOAgent)(agent = this.createMx4jAgent()))) {
                MuleManager.getInstance().registerAgent((UMOAgent)agent);
            }
            MuleManager.getInstance().unregisterAgent(this.name);
        }
        catch (UMOException e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
    }

    protected JmxAgent createJmxAgent() {
        JmxAgent agent = new JmxAgent();
        String remotingUri = null;
        if (StringUtils.isBlank((String)this.host) && StringUtils.isBlank((String)this.port)) {
            remotingUri = "service:jmx:rmi:///jndi/rmi://localhost:1099/server";
        } else if (StringUtils.isNotBlank((String)this.host)) {
            Map props = agent.getConnectorServerProperties();
            HashMap<String, FixedHostRmiClientSocketFactory> mergedProps = new HashMap<String, FixedHostRmiClientSocketFactory>(props.size() + 1);
            mergedProps.putAll(props);
            FixedHostRmiClientSocketFactory factory = new FixedHostRmiClientSocketFactory(this.host);
            mergedProps.put("jmx.remote.rmi.client.socket.factory", factory);
            agent.setConnectorServerProperties(mergedProps);
        }
        if (StringUtils.isBlank((String)remotingUri)) {
            remotingUri = MessageFormat.format("service:jmx:rmi:///jndi/rmi://{0}:{1}/server", StringUtils.defaultString((String)this.host, (String)DEFAULT_HOST), StringUtils.defaultString((String)this.port, (String)DEFAULT_PORT));
        }
        if (this.credentials != null && !this.credentials.isEmpty()) {
            agent.setCredentials(this.credentials);
        }
        agent.setConnectorServerUrl(remotingUri);
        return agent;
    }

    protected Log4jAgent createLog4jAgent() {
        return new Log4jAgent();
    }

    protected RmiRegistryAgent createRmiAgent() {
        RmiRegistryAgent agent = new RmiRegistryAgent();
        agent.setHost(StringUtils.defaultString((String)this.host, (String)DEFAULT_HOST));
        agent.setPort(StringUtils.defaultString((String)this.port, (String)DEFAULT_PORT));
        return agent;
    }

    protected JmxServerNotificationAgent createJmxNotificationAgent() {
        return new JmxServerNotificationAgent();
    }

    protected Mx4jAgent createMx4jAgent() {
        return new Mx4jAgent();
    }

    protected JdmkAgent createJdmkAgent() {
        return new JdmkAgent();
    }

    protected boolean isAgentRegistered(UMOAgent agent) {
        return MuleManager.getInstance().lookupAgent(agent.getName()) != null;
    }

    public boolean isLoadJdmkAgent() {
        return this.loadJdmkAgent;
    }

    public void setLoadJdmkAgent(boolean loadJdmkAgent) {
        this.loadJdmkAgent = loadJdmkAgent;
    }

    public boolean isLoadMx4jAgent() {
        return this.loadMx4jAgent;
    }

    public void setLoadMx4jAgent(boolean loadMx4jAgent) {
        this.loadMx4jAgent = loadMx4jAgent;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setCredentials(Map credentials) {
        this.credentials = credentials;
    }
}

