/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.File;
import java.io.IOException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.FileUtils;

public class ManagementContext {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected String jmxDomainName;
    protected File workingDir;
    protected TransactionManager transactionManager;
    protected MBeanServer mBeanServer;
    protected InitialContext namingContext;
    public static final String TEMP_DIR = "temp";
    public static final String COMPONENTS_DIR = "components";
    public static final String LIBRARIES_DIR = "libraries";
    public static final String ASSEMBLIES_DIR = "assemblies";
    public static final String INSTALL_DIR = "install";
    public static final String DEPLOY_DIR = "deploy";
    public static final String PROCESSED_DIR = "processed";
    public static final String WORKSPACE_DIR = "workspace";
    private int counter;

    public String getJmxDomainName() {
        return this.jmxDomainName;
    }

    public void setJmxDomainName(String jmxDomainName) {
        this.jmxDomainName = jmxDomainName;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public InitialContext getNamingContext() {
        return this.namingContext;
    }

    public void setNamingContext(InitialContext namingContext) {
        this.namingContext = namingContext;
    }

    public ObjectName createMBeanName(String componentName, String type, String name) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getJmxDomainName()).append(':');
            if (componentName != null) {
                sb.append("component=").append(this.validateString(componentName));
                sb.append(',');
            }
            sb.append("type=").append(this.validateString(type));
            if (name != null) {
                sb.append(',');
                sb.append("name=").append(this.validateString(name));
            }
            return new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            this.logger.error((Object)"Could not create component mbean name", (Throwable)e);
            return null;
        }
    }

    private String validateString(String str) {
        str = str.replace(':', '_');
        str = str.replace('/', '_');
        str = str.replace('\\', '_');
        return str;
    }

    public synchronized File getNewTempDir(File rootDir) {
        String s;
        File f;
        do {
            s = Integer.toHexString(++this.counter);
            while (s.length() < 8) {
                s = "0" + s;
            }
        } while ((f = FileUtils.newFile((File)rootDir, (String)(File.separator + TEMP_DIR + File.separator + s))).exists());
        return f;
    }

    public File getComponentInstallDir(File rootDir, String name) {
        return FileUtils.newFile((File)rootDir, (String)(COMPONENTS_DIR + File.separator + this.validateString(name)));
    }

    public File getComponentWorkspaceDir(File rootDir, String name) {
        return FileUtils.newFile((File)rootDir, (String)(WORKSPACE_DIR + File.separator + this.validateString(name)));
    }

    public File getLibraryInstallDir(File rootDir, String name) {
        return FileUtils.newFile((File)rootDir, (String)(LIBRARIES_DIR + File.separator + this.validateString(name)));
    }

    public File getAssemblyInstallDir(File rootDir, String name) {
        return FileUtils.newFile((File)rootDir, (String)(ASSEMBLIES_DIR + File.separator + this.validateString(name)));
    }

    public static File getAutoInstallDir(File rootDir) {
        return FileUtils.newFile((File)rootDir, (String)INSTALL_DIR);
    }

    public File getAutoInstallProcessedDir(File rootDir) {
        return FileUtils.newFile((File)rootDir, (String)(INSTALL_DIR + File.separator + PROCESSED_DIR));
    }

    public File getAutoDeployDir(File rootDir) {
        return FileUtils.newFile((File)rootDir, (String)DEPLOY_DIR);
    }

    public File getAutoDeployProcessedDir(File rootDir) {
        return FileUtils.newFile((File)rootDir, (String)(DEPLOY_DIR + File.separator + PROCESSED_DIR));
    }

    public void deleteMarkedDirectories(File dir) {
        if (dir != null && dir.isDirectory()) {
            if (FileUtils.newFile((File)dir, (String)".delete").isFile()) {
                this.deleteDir(dir);
            } else {
                File[] children = dir.listFiles();
                for (int i = 0; i < children.length; ++i) {
                    if (!children[i].isDirectory()) continue;
                    this.deleteMarkedDirectories(children[i]);
                }
            }
        }
    }

    public void deleteDir(String dir) {
        this.deleteDir(FileUtils.newFile((String)dir));
    }

    public void deleteDir(File dir) {
        FileUtils.deleteTree((File)dir);
        if (dir.isDirectory()) {
            try {
                FileUtils.newFile((File)dir, (String)".delete").createNewFile();
            }
            catch (IOException e) {
                this.logger.warn((Object)"Could not mark directory to be deleted", (Throwable)e);
            }
        }
    }

    public void createDirectories(File rootDir) throws IOException {
        FileUtils.createFile((String)rootDir.getAbsolutePath());
        FileUtils.createFile((String)new File(rootDir, COMPONENTS_DIR).getAbsolutePath());
        FileUtils.createFile((String)new File(rootDir, WORKSPACE_DIR).getAbsolutePath());
        FileUtils.createFile((String)new File(rootDir, LIBRARIES_DIR).getAbsolutePath());
        FileUtils.createFile((String)new File(rootDir, ASSEMBLIES_DIR).getAbsolutePath());
        FileUtils.createFile((String)ManagementContext.getAutoInstallDir(rootDir).getAbsolutePath());
        FileUtils.createFile((String)this.getAutoDeployDir(rootDir).getAbsolutePath());
        FileUtils.createFile((String)this.getAutoDeployProcessedDir(rootDir).getAbsolutePath());
    }
}

