/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.agents;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.util.ArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.management.support.AutoDiscoveryJmxSupportFactory;
import org.mule.management.support.JmxSupport;
import org.mule.management.support.JmxSupportFactory;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.tanukisoftware.wrapper.jmx.WrapperManager;
import org.tanukisoftware.wrapper.jmx.WrapperManagerMBean;

public class WrapperManagerAgent
implements UMOAgent {
    public static final String WRAPPER_OBJECT_NAME = "name=WrapperManager";
    private static final Log logger = LogFactory.getLog((Class)WrapperManagerAgent.class);
    private static final String WRAPPER_SYSTEM_PROPERTY_NAME = "wrapper.native_library";
    private String name = "Wrapper Manager";
    private MBeanServer mBeanServer;
    private ObjectName wrapperName;
    private JmxSupportFactory jmxSupportFactory = AutoDiscoveryJmxSupportFactory.getInstance();
    private JmxSupport jmxSupport = this.jmxSupportFactory.getJmxSupport();
    private final AtomicReference wrapperManagerRef = new AtomicReference();

    public void initialise() throws InitialisationException {
        boolean launchedByWrapper;
        if (System.getProperty(WRAPPER_SYSTEM_PROPERTY_NAME) == null) {
            launchedByWrapper = false;
        } else {
            this.lazyInitWrapperManager();
            launchedByWrapper = ((WrapperManagerMBean)this.wrapperManagerRef.get()).isControlledByNativeWrapper();
        }
        if (!launchedByWrapper) {
            logger.info((Object)"This JVM hasn't been launched by the wrapper, the agent will not run.");
            try {
                MuleManager.getInstance().unregisterAgent(this.getName());
            }
            catch (UMOException e) {
                // empty catch block
            }
            return;
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers.isEmpty()) {
            throw new RuntimeException("no mbean servers found");
        }
        try {
            this.mBeanServer = (MBeanServer)servers.get(0);
            this.wrapperName = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName() + ":" + WRAPPER_OBJECT_NAME);
            this.unregisterMBeansIfNecessary();
            this.mBeanServer.registerMBean(this.wrapperManagerRef.get(), this.wrapperName);
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(42, (Object)"wrapper agent"), (Throwable)e, (Object)this);
        }
    }

    protected void lazyInitWrapperManager() {
        WrapperManagerMBean wm = (WrapperManagerMBean)this.wrapperManagerRef.get();
        if (wm != null) {
            return;
        }
        wm = new WrapperManager();
        this.wrapperManagerRef.compareAndSet(null, (Object)wm);
    }

    public void start() throws UMOException {
    }

    public void stop() throws UMOException {
    }

    protected void unregisterMBeansIfNecessary() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        if (this.mBeanServer == null || this.wrapperName != null) {
            return;
        }
        if (this.mBeanServer.isRegistered(this.wrapperName)) {
            this.mBeanServer.unregisterMBean(this.wrapperName);
        }
    }

    public void dispose() {
        try {
            this.unregisterMBeansIfNecessary();
        }
        catch (Exception e) {
            logger.error((Object)("Couldn't unregister MBean: " + (this.wrapperName != null ? this.wrapperName.getCanonicalName() : "null")), (Throwable)e);
        }
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public String getDescription() {
        WrapperManagerMBean wm = (WrapperManagerMBean)this.wrapperManagerRef.get();
        if (wm == null) {
            return "Wrapper Manager";
        }
        return "Wrapper Manager: Mule PID #" + wm.getJavaPID() + ", Wrapper PID #" + wm.getWrapperPID();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

