/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.agents;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.Message;
import org.mule.impl.internal.notifications.ModelNotificationListener;
import org.mule.impl.internal.notifications.NotificationException;
import org.mule.management.agents.JmxManagementException;
import org.mule.management.mbeans.ComponentService;
import org.mule.management.mbeans.ConnectorService;
import org.mule.management.mbeans.EndpointService;
import org.mule.management.mbeans.ModelService;
import org.mule.management.mbeans.MuleConfigurationService;
import org.mule.management.mbeans.MuleService;
import org.mule.management.mbeans.StatisticsService;
import org.mule.providers.AbstractConnector;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;

public class JmxAgent
implements UMOAgent {
    protected static transient Log logger = LogFactory.getLog((Class)JmxAgent.class);
    private String name = "JMX Agent";
    protected boolean locateServer = true;
    private boolean createServer = true;
    private String connectorServerUrl;
    private MBeanServer mBeanServer;
    private JMXConnectorServer connectorServer;
    private Map connectorServerProperties = null;
    private boolean enableStatistics = true;
    private List registeredMBeans = new ArrayList();
    private boolean serverCreated = false;
    private boolean initialized = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        if (this.connectorServerUrl != null) {
            return "JMX Agent: " + this.connectorServerUrl;
        }
        return "JMX Agent";
    }

    public void initialise() throws InitialisationException {
        Object l;
        if (this.initialized) {
            return;
        }
        if (!this.locateServer && !this.createServer) {
            throw new InitialisationException(new Message(113), (Object)this);
        }
        if (this.mBeanServer == null && this.locateServer && (l = MBeanServerFactory.findMBeanServer(null)) != null && l.size() > 0) {
            this.mBeanServer = (MBeanServer)l.get(0);
        }
        if (this.mBeanServer == null && this.createServer) {
            this.mBeanServer = MBeanServerFactory.createMBeanServer();
            this.serverCreated = true;
        }
        if (this.mBeanServer == null) {
            throw new InitialisationException(new Message(114), (Object)this);
        }
        if (this.connectorServerUrl != null) {
            try {
                JMXServiceURL url = new JMXServiceURL(this.connectorServerUrl);
                this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, this.connectorServerProperties, this.mBeanServer);
            }
            catch (Exception e) {
                throw new InitialisationException(new Message(65, (Object)"Jmx Connector"), (Throwable)e, (Object)this);
            }
        }
        l = new ModelNotificationListener(){

            public void onNotification(UMOServerNotification notification) {
                if (notification.getAction() == 206) {
                    try {
                        JmxAgent.this.registerStatisticsService();
                        JmxAgent.this.registerMuleService();
                        JmxAgent.this.registerConfigurationService();
                        JmxAgent.this.registerModelService();
                        JmxAgent.this.registerComponentServices();
                        JmxAgent.this.registerEndpointServices();
                        JmxAgent.this.registerConnectorServices();
                    }
                    catch (Exception e) {
                        throw new MuleRuntimeException(new Message(40, (Object)"MBeans"), (Throwable)e);
                    }
                }
            }
        };
        try {
            MuleManager.getInstance().registerListener((UMOServerNotificationListener)l);
        }
        catch (NotificationException e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
        this.initialized = true;
    }

    public void start() throws UMOException {
        if (this.connectorServer != null) {
            try {
                logger.info((Object)"Starting JMX agent connector Server");
                this.connectorServer.start();
            }
            catch (Exception e) {
                throw new JmxManagementException(new Message(42, (Object)"Jmx Connector"), e);
            }
        }
    }

    public void stop() throws UMOException {
        if (this.connectorServer != null) {
            try {
                this.connectorServer.stop();
            }
            catch (Exception e) {
                throw new JmxManagementException(new Message(41, (Object)"Jmx Connector"), e);
            }
        }
    }

    public void dispose() {
        if (this.mBeanServer != null) {
            Iterator iterator = this.registeredMBeans.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                try {
                    this.mBeanServer.unregisterMBean(objectName);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to unregister MBean: " + objectName + ". Error is: " + e.getMessage()));
                }
            }
            if (this.serverCreated) {
                MBeanServerFactory.releaseMBeanServer(this.mBeanServer);
            }
            this.mBeanServer = null;
        }
    }

    public void registered() {
    }

    public void unregistered() {
    }

    protected String getDomainName() {
        return "Mule";
    }

    protected void registerStatisticsService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = ObjectName.getInstance(this.getDomainName() + ":type=org.mule.Statistics,name=AllStatistics");
        StatisticsService mBean = new StatisticsService();
        mBean.setManager(MuleManager.getInstance());
        mBean.setEnabled(this.isEnableStatistics());
        logger.debug((Object)("Registering statistics with name: " + on));
        this.mBeanServer.registerMBean(mBean, on);
        this.registeredMBeans.add(on);
    }

    protected void registerModelService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ModelService serviceMBean = new ModelService();
        String name = serviceMBean.getName() + "(" + serviceMBean.getType() + ")";
        ObjectName on = ObjectName.getInstance(this.getDomainName() + ":type=org.mule.Model,name=" + name);
        logger.debug((Object)("Registering model with name: " + on));
        this.mBeanServer.registerMBean(serviceMBean, on);
        this.registeredMBeans.add(on);
    }

    protected void registerMuleService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = ObjectName.getInstance(this.getDomainName() + ":type=org.mule.ManagementContext,name=MuleServerInfo");
        MuleService serviceMBean = new MuleService();
        logger.debug((Object)("Registering mule with name: " + on));
        this.mBeanServer.registerMBean(serviceMBean, on);
        this.registeredMBeans.add(on);
    }

    protected void registerConfigurationService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = ObjectName.getInstance(this.getDomainName() + ":type=org.mule.Configuration,name=GlobalConfiguration");
        MuleConfigurationService serviceMBean = new MuleConfigurationService();
        logger.debug((Object)("Registering configuration with name: " + on));
        this.mBeanServer.registerMBean(serviceMBean, on);
        this.registeredMBeans.add(on);
    }

    protected void registerComponentServices() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        Iterator iter = MuleManager.getInstance().getModel().getComponentNames();
        while (iter.hasNext()) {
            String name = iter.next().toString();
            ObjectName on = ObjectName.getInstance(this.getDomainName() + ":type=org.mule.Component,name=" + name);
            ComponentService serviceMBean = new ComponentService(name);
            logger.debug((Object)("Registering component with name: " + on));
            this.mBeanServer.registerMBean(serviceMBean, on);
            this.registeredMBeans.add(on);
        }
    }

    protected void registerEndpointServices() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        Iterator iter = MuleManager.getInstance().getConnectors().values().iterator();
        while (iter.hasNext()) {
            UMOConnector connector = (UMOConnector)iter.next();
            if (connector instanceof AbstractConnector) {
                Iterator iterator = ((AbstractConnector)connector).getReceivers().values().iterator();
                while (iterator.hasNext()) {
                    EndpointService mBean = new EndpointService((UMOMessageReceiver)iterator.next());
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Attempting to register service with name: " + this.getDomainName() + ":type=org.mule.umo.UMOEndpoint,name=" + mBean.getName()));
                    }
                    ObjectName on = ObjectName.getInstance(this.getDomainName() + ":type=org.mule.Endpoint,component=" + mBean.getComponentName() + ",name=" + mBean.getName());
                    this.mBeanServer.registerMBean(mBean, on);
                    this.registeredMBeans.add(on);
                    logger.info((Object)("Registered Endpoint Service with name: " + on));
                }
                continue;
            }
            logger.warn((Object)("Connector: " + connector + " is not an istance of AbstractConnector, cannot obtain Endpoint MBeans from it"));
        }
    }

    protected void registerConnectorServices() throws MalformedObjectNameException, NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        Iterator iter = MuleManager.getInstance().getConnectors().values().iterator();
        while (iter.hasNext()) {
            UMOConnector connector = (UMOConnector)iter.next();
            ConnectorService mBean = new ConnectorService(connector);
            String stringName = this.getDomainName() + ":type=org.mule.Connector,name=" + mBean.getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attempting to register service with name: " + stringName));
            }
            ObjectName oName = ObjectName.getInstance(stringName);
            this.mBeanServer.registerMBean(mBean, oName);
            this.registeredMBeans.add(oName);
            logger.info((Object)("Registered Connector Service with name " + oName));
        }
    }

    public boolean isCreateServer() {
        return this.createServer;
    }

    public void setCreateServer(boolean createServer) {
        this.createServer = createServer;
    }

    public boolean isLocateServer() {
        return this.locateServer;
    }

    public void setLocateServer(boolean locateServer) {
        this.locateServer = locateServer;
    }

    public String getConnectorServerUrl() {
        return this.connectorServerUrl;
    }

    public void setConnectorServerUrl(String connectorServerUrl) {
        this.connectorServerUrl = connectorServerUrl;
    }

    public boolean isEnableStatistics() {
        return this.enableStatistics;
    }

    public void setEnableStatistics(boolean enableStatistics) {
        this.enableStatistics = enableStatistics;
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public Map getConnectorServerProperties() {
        return this.connectorServerProperties;
    }

    public void setConnectorServerProperties(Map connectorServerProperties) {
        this.connectorServerProperties = connectorServerProperties;
    }
}

