/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentListenerManager;

public class CompositeDeploymentListener
implements DeploymentListener,
DeploymentListenerManager {
    private final transient Log logger = LogFactory.getLog(this.getClass());
    private List<DeploymentListener> deploymentListeners = new CopyOnWriteArrayList<DeploymentListener>();

    @Override
    public void addDeploymentListener(DeploymentListener listener) {
        this.deploymentListeners.add(listener);
    }

    @Override
    public void removeDeploymentListener(DeploymentListener listener) {
        this.deploymentListeners.remove(listener);
    }

    @Override
    public void onDeploymentStart(String artifactName) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onDeploymentStart(artifactName);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(artifactName, listener, "onDeploymentStart", t);
            }
        }
    }

    @Override
    public void onDeploymentSuccess(String appName) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onDeploymentSuccess(appName);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(appName, listener, "onDeploymentSuccess", t);
            }
        }
    }

    @Override
    public void onDeploymentFailure(String artifactName, Throwable cause) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onDeploymentFailure(artifactName, cause);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(artifactName, listener, "onDeploymentFailure", t);
            }
        }
    }

    @Override
    public void onUndeploymentStart(String artifactName) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onUndeploymentStart(artifactName);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(artifactName, listener, "onUndeploymentStart", t);
            }
        }
    }

    @Override
    public void onUndeploymentSuccess(String artifactName) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onUndeploymentSuccess(artifactName);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(artifactName, listener, "onUndeploymentSuccess", t);
            }
        }
    }

    @Override
    public void onUndeploymentFailure(String artifactName, Throwable cause) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onUndeploymentFailure(artifactName, cause);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(artifactName, listener, "onUndeploymentFailure", t);
            }
        }
    }

    @Override
    public void onMuleContextCreated(String artifactName, MuleContext context) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onMuleContextCreated(artifactName, context);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(artifactName, listener, "onMuleContextCreated", t);
            }
        }
    }

    @Override
    public void onMuleContextInitialised(String artifactName, MuleContext context) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onMuleContextInitialised(artifactName, context);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(artifactName, listener, "onMuleContextInitialised", t);
            }
        }
    }

    @Override
    public void onMuleContextConfigured(String artifactName, MuleContext context) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onMuleContextConfigured(artifactName, context);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(artifactName, listener, "onMuleContextConfigured", t);
            }
        }
    }

    private void logNotificationProcessingError(String appName, DeploymentListener listener, String notification, Throwable error) {
        this.logger.error((Object)String.format("Listener '%s' failed to process notification '%s' for application '%s'", listener, notification, appName), error);
    }
}

