/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.plugin;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.launcher.plugin.PluginClasspath;
import org.mule.module.launcher.plugin.PluginDescriptor;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.FileUtils;
import org.mule.util.StringUtils;

public class PluginDescriptorParser {
    protected static final String PROPERTY_LOADER_OVERRIDE = "loader.override";
    private ApplicationDescriptor appDescriptor;
    private File appDir;

    public PluginDescriptorParser(ApplicationDescriptor appDescriptor, File appDir) {
        this.appDescriptor = appDescriptor;
        this.appDir = appDir;
    }

    public Set<PluginDescriptor> parse() throws IOException {
        File pluginsDir = new File(this.appDir, "plugins");
        Object[] pluginZips = pluginsDir.list((FilenameFilter)new SuffixFileFilter(".zip"));
        if (pluginZips == null || pluginZips.length == 0) {
            return Collections.emptySet();
        }
        Arrays.sort(pluginZips);
        HashSet<PluginDescriptor> pds = new HashSet<PluginDescriptor>(pluginZips.length);
        for (Object pluginZip : pluginZips) {
            String pluginName = StringUtils.removeEnd((String)pluginZip, (String)".zip");
            File tmpDir = new File(MuleContainerBootstrapUtils.getMuleTmpDir(), this.appDescriptor.getName() + "/plugins/" + pluginName);
            FileUtils.unzip((File)new File(pluginsDir, (String)pluginZip), (File)tmpDir);
            PluginDescriptor pd = new PluginDescriptor();
            pd.setName(pluginName);
            pd.setAppDescriptor(this.appDescriptor);
            File pluginPropsFile = new File(tmpDir, "plugin.properties");
            if (pluginPropsFile.exists()) {
                Properties props = new Properties();
                props.load(new FileReader(pluginPropsFile));
                String overrideString = props.getProperty(PROPERTY_LOADER_OVERRIDE);
                if (StringUtils.isNotBlank((String)overrideString)) {
                    HashSet<String> values = new HashSet<String>();
                    String[] overrides = overrideString.split(",");
                    Collections.addAll(values, overrides);
                    pd.setLoaderOverride(values);
                }
            }
            PluginClasspath cp = PluginClasspath.from(tmpDir);
            pd.setClasspath(cp);
            pds.add(pd);
        }
        return pds;
    }

    public ApplicationDescriptor getAppDescriptor() {
        return this.appDescriptor;
    }

    public File getAppDir() {
        return this.appDir;
    }
}

