/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.application;

import java.util.LinkedList;
import java.util.List;
import org.mule.module.launcher.PluginClassLoaderManager;
import org.mule.module.launcher.application.ApplicationClassLoaderFactory;
import org.mule.module.launcher.application.CompositeApplicationClassLoader;
import org.mule.module.launcher.artifact.ArtifactClassLoader;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;

public class CompositeApplicationClassLoaderFactory
implements ApplicationClassLoaderFactory {
    private final PluginClassLoaderManager pluginClassLoaderManager;
    private final ApplicationClassLoaderFactory applicationClassLoaderFactory;

    public CompositeApplicationClassLoaderFactory(ApplicationClassLoaderFactory applicationClassLoaderFactory, PluginClassLoaderManager pluginClassLoaderManager) {
        this.applicationClassLoaderFactory = applicationClassLoaderFactory;
        this.pluginClassLoaderManager = pluginClassLoaderManager;
    }

    @Override
    public ArtifactClassLoader create(ApplicationDescriptor descriptor) {
        List<ClassLoader> pluginClassLoaders = this.pluginClassLoaderManager.getPluginClassLoaders();
        ArtifactClassLoader appClassLoader = this.applicationClassLoaderFactory.create(descriptor);
        if (!pluginClassLoaders.isEmpty()) {
            LinkedList<ClassLoader> classLoaders = new LinkedList<ClassLoader>();
            classLoaders.add(appClassLoader.getClassLoader());
            classLoaders.addAll(pluginClassLoaders);
            appClassLoader = new CompositeApplicationClassLoader(descriptor.getName(), classLoaders);
        }
        return appClassLoader;
    }
}

