/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.application;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.launcher.DisposableClassLoader;
import org.mule.module.launcher.MuleApplicationClassLoader;
import org.mule.module.launcher.application.ApplicationClassLoader;
import org.mule.module.launcher.application.EnumerationAdapter;
import org.mule.module.launcher.artifact.ArtifactClassLoader;
import org.mule.module.launcher.artifact.ShutdownListener;

public class CompositeApplicationClassLoader
extends ClassLoader
implements ApplicationClassLoader {
    protected static final Log logger = LogFactory.getLog(CompositeApplicationClassLoader.class);
    private final List<ClassLoader> classLoaders;
    private final String appName;

    public CompositeApplicationClassLoader(String appName, List<ClassLoader> classLoaders) {
        this.appName = appName;
        this.classLoaders = new LinkedList<ClassLoader>(classLoaders);
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                Class<?> aClass = classLoader.loadClass(name);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Class '%s' loaded from classLoader '%s", name, classLoader));
                }
                return aClass;
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(String.format("Cannot load class '%s'", name));
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                Class<?> aClass = this.loadClass(classLoader, name, resolve);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Class '%s' loaded from classLoader '%s", name, classLoader));
                }
                return aClass;
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(String.format("Cannot load class '%s'", name));
    }

    protected Class<?> loadClass(ClassLoader classLoader, String name, boolean resolve) throws ClassNotFoundException {
        try {
            Method loadClassMethod = this.findDeclaredMethod(classLoader, "loadClass", String.class, Boolean.TYPE);
            return (Class)loadClassMethod.invoke((Object)classLoader, name, resolve);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                this.logReflectionLoadingError(name, classLoader, e, "Class");
            }
            throw new ClassNotFoundException(String.format("Cannot load class '%s'", name));
        }
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classLoader : this.classLoaders) {
            URL resource = classLoader.getResource(name);
            if (resource == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Resource '%s' loaded from classLoader '%s", name, classLoader));
            }
            return resource;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader classLoader : this.classLoaders) {
            InputStream resourceAsStream = classLoader.getResourceAsStream(name);
            if (resourceAsStream == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Stream resource '%s' loaded from classLoader '%s", name, classLoader));
            }
            return resourceAsStream;
        }
        return null;
    }

    @Override
    protected String findLibrary(String libname) {
        for (ClassLoader classLoader : this.classLoaders) {
            String library = this.findLibrary(libname, classLoader);
            if (library == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Library '%s' found in classLoader '%s", libname, classLoader));
            }
            return library;
        }
        return null;
    }

    protected String findLibrary(String libname, ClassLoader classLoader) {
        try {
            Method findLibraryMethod = this.findDeclaredMethod(classLoader, "findLibrary", String.class);
            return (String)findLibraryMethod.invoke((Object)classLoader, libname);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                this.logReflectionLoadingError(libname, classLoader, e, "Library");
            }
            return null;
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        HashMap<String, URL> resources = new HashMap<String, URL>();
        for (ClassLoader classLoader : this.classLoaders) {
            Enumeration<URL> partialResources = classLoader.getResources(name);
            while (partialResources.hasMoreElements()) {
                URL url = partialResources.nextElement();
                if (resources.get(url.toString()) != null) continue;
                resources.put(url.toString(), url);
            }
        }
        return new EnumerationAdapter<URL>(resources.values());
    }

    @Override
    public String getArtifactName() {
        return this.appName;
    }

    @Override
    public URL findResource(String name) {
        for (ClassLoader classLoader : this.classLoaders) {
            URL resource = this.findResource(classLoader, name);
            if (resource == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Resource '%s' loaded from classLoader '%s", name, classLoader));
            }
            return resource;
        }
        return null;
    }

    @Override
    public URL findLocalResource(String resourceName) {
        for (ClassLoader classLoader : this.classLoaders) {
            URL resource;
            if (!(classLoader instanceof ArtifactClassLoader) || (resource = ((ArtifactClassLoader)((Object)classLoader)).findLocalResource(resourceName)) == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this;
    }

    @Override
    public void dispose() {
        for (ClassLoader classLoader : this.classLoaders) {
            if (!(classLoader instanceof DisposableClassLoader)) continue;
            ((DisposableClassLoader)((Object)classLoader)).dispose();
        }
    }

    @Override
    public void addShutdownListener(ShutdownListener listener) {
        for (ClassLoader classLoader : this.classLoaders) {
            if (!(classLoader instanceof MuleApplicationClassLoader)) continue;
            ((ApplicationClassLoader)((Object)classLoader)).addShutdownListener(listener);
            return;
        }
    }

    private URL findResource(ClassLoader classLoader, String name) {
        try {
            Method findResourceMethod = this.findDeclaredMethod(classLoader, "findResource", String.class);
            return (URL)findResourceMethod.invoke((Object)classLoader, name);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                this.logReflectionLoadingError(name, classLoader, e, "Resource");
            }
            return null;
        }
    }

    private Method findDeclaredMethod(ClassLoader classLoader, String methodName, Class<?> ... params) throws NoSuchMethodException {
        for (Class<?> clazz = classLoader.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Method findLibraryMethod = clazz.getDeclaredMethod(methodName, params);
                findLibraryMethod.setAccessible(true);
                return findLibraryMethod;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        throw new NoSuchMethodException(String.format("Cannot find a method '%s' with the given parameter types '%s'", methodName, Arrays.toString(params)));
    }

    private void logReflectionLoadingError(String name, ClassLoader classLoader, Exception e, String type) {
        if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() instanceof ClassNotFoundException) {
            logger.debug((Object)String.format("'%s' '%s' not found in class loader '%s'", type, name, classLoader));
        } else {
            String errorMessage = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException().getMessage() : e.getMessage();
            logger.debug((Object)String.format("Error loading '%s' '%s' from class loader '%s': '%s'", type.toLowerCase(), name, classLoader, errorMessage));
        }
    }
}

