/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.nativelib;

import java.io.File;
import org.mule.module.launcher.nativelib.NativeLibraryFinder;
import org.mule.util.SystemUtils;

public class PerAppNativeLibraryFinder
implements NativeLibraryFinder {
    public static final String DYLIB_EXTENSION = ".dylib";
    public static final String JNILIB_EXTENSION = ".jnilib";
    private final File libDir;

    public PerAppNativeLibraryFinder(File libDir) {
        this.libDir = libDir;
    }

    @Override
    public String findLibrary(String name, String libraryPath) {
        if (null == libraryPath) {
            libraryPath = this.findLibraryLocally(name);
        }
        return libraryPath;
    }

    protected String findLibraryLocally(String name) {
        String nativeLibName = System.mapLibraryName(name);
        File library = new File(this.libDir, nativeLibName);
        if (!library.exists() && SystemUtils.IS_OS_MAC) {
            nativeLibName = nativeLibName.replace(DYLIB_EXTENSION, JNILIB_EXTENSION);
            library = new File(this.libDir, nativeLibName);
        }
        if (library.exists()) {
            return library.getAbsolutePath();
        }
        return null;
    }
}

