/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.application;

import java.util.Set;
import org.mule.module.launcher.MuleApplicationClassLoader;
import org.mule.module.launcher.application.ApplicationClassLoaderFactory;
import org.mule.module.launcher.artifact.ArtifactClassLoader;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.launcher.domain.DomainClassLoaderRepository;
import org.mule.module.launcher.nativelib.NativeLibraryFinderFactory;
import org.mule.module.launcher.plugin.MulePluginsClassLoader;
import org.mule.module.launcher.plugin.PluginDescriptor;

public class MuleApplicationClassLoaderFactory
implements ApplicationClassLoaderFactory {
    private final DomainClassLoaderRepository domainClassLoaderRepository;
    private final NativeLibraryFinderFactory nativeLibraryFinderFactory;

    public MuleApplicationClassLoaderFactory(DomainClassLoaderRepository domainClassLoaderRepository, NativeLibraryFinderFactory nativeLibraryFinderFactory) {
        this.domainClassLoaderRepository = domainClassLoaderRepository;
        this.nativeLibraryFinderFactory = nativeLibraryFinderFactory;
    }

    @Override
    public ArtifactClassLoader create(ApplicationDescriptor descriptor) {
        String domain = descriptor.getDomain();
        ClassLoader parent = domain == null ? this.domainClassLoaderRepository.getDefaultDomainClassLoader().getClassLoader() : this.domainClassLoaderRepository.getDomainClassLoader(domain).getClassLoader();
        Set<PluginDescriptor> plugins = descriptor.getPlugins();
        if (!plugins.isEmpty()) {
            parent = new MulePluginsClassLoader(parent, plugins);
        }
        return new MuleApplicationClassLoader(descriptor.getAppName(), parent, descriptor.getLoaderOverride(), this.nativeLibraryFinderFactory.create(descriptor.getAppName()));
    }
}

