/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.application;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.mule.module.launcher.DefaultAppBloodhound;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.application.ApplicationClassLoaderFactory;
import org.mule.module.launcher.application.ApplicationFactory;
import org.mule.module.launcher.application.ApplicationWrapper;
import org.mule.module.launcher.application.DefaultMuleApplication;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.launcher.domain.Domain;
import org.mule.module.launcher.domain.DomainFactory;
import org.mule.module.reboot.MuleContainerBootstrapUtils;

public class DefaultApplicationFactory
implements ApplicationFactory {
    private final ApplicationClassLoaderFactory applicationClassLoaderFactory;
    private final DomainFactory domainFactory;
    protected DeploymentListener deploymentListener;

    public DefaultApplicationFactory(ApplicationClassLoaderFactory applicationClassLoaderFactory, DomainFactory domainFactory) {
        this.applicationClassLoaderFactory = applicationClassLoaderFactory;
        this.domainFactory = domainFactory;
    }

    public void setDeploymentListener(DeploymentListener deploymentListener) {
        this.deploymentListener = deploymentListener;
    }

    @Override
    public Application createArtifact(String appName) throws IOException {
        if (appName.contains(" ")) {
            throw new IllegalArgumentException("Mule application name may not contain spaces: " + appName);
        }
        DefaultAppBloodhound bh = new DefaultAppBloodhound();
        ApplicationDescriptor descriptor = bh.fetch(appName);
        return this.createAppFrom(descriptor);
    }

    @Override
    public File getArtifactDir() {
        return MuleContainerBootstrapUtils.getMuleAppsDir();
    }

    protected Application createAppFrom(ApplicationDescriptor descriptor) throws IOException {
        DefaultMuleApplication delegate = StringUtils.isEmpty((String)descriptor.getDomain()) ? new DefaultMuleApplication(descriptor, this.applicationClassLoaderFactory, this.domainFactory.createDefaultDomain()) : new DefaultMuleApplication(descriptor, this.applicationClassLoaderFactory, (Domain)this.domainFactory.createArtifact(descriptor.getDomain()));
        if (this.deploymentListener != null) {
            delegate.setDeploymentListener(this.deploymentListener);
        }
        return new ApplicationWrapper(delegate);
    }
}

