/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.descriptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.launcher.descriptor.DescriptorParser;
import org.mule.util.PropertiesUtils;
import org.mule.util.StringUtils;

public class PropertiesDescriptorParser
implements DescriptorParser {
    protected static final String PROPERTY_ENCODING = "encoding";
    protected static final String PROPERTY_CONFIG_BUILDER = "config.builder";
    protected static final String PROPERTY_DOMAIN = "domain";
    protected static final String PROPERTY_CONFIG_RESOURCES = "config.resources";
    protected static final String PROPERTY_REDEPLOYMENT_ENABLED = "redeployment.enabled";
    protected static final String PROPERTY_LEGACY_PRIVILEGED = "priviledged";
    protected static final String PROPERTY_PRIVILEGED = "privileged";
    protected static final String PROPERTY_LOADER_OVERRIDE = "loader.override";
    protected static final String PROPERTY_SCAN_PACKAGES = "scan.packages";

    @Override
    public ApplicationDescriptor parse(File descriptor) throws IOException {
        Properties p = PropertiesUtils.loadProperties((InputStream)new FileInputStream(descriptor));
        ApplicationDescriptor d = new ApplicationDescriptor();
        d.setEncoding(p.getProperty(PROPERTY_ENCODING));
        d.setConfigurationBuilder(p.getProperty(PROPERTY_CONFIG_BUILDER));
        d.setDomain(p.getProperty(PROPERTY_DOMAIN));
        d.setPackagesToScan(p.getProperty(PROPERTY_SCAN_PACKAGES));
        String resProps = p.getProperty(PROPERTY_CONFIG_RESOURCES);
        String[] urls = StringUtils.isBlank((String)resProps) ? new String[]{"mule-config.xml"} : resProps.split(",");
        d.setConfigResources(urls);
        d.setRedeploymentEnabled(BooleanUtils.toBoolean((String)p.getProperty(PROPERTY_REDEPLOYMENT_ENABLED, Boolean.TRUE.toString())));
        d.setPrivileged(BooleanUtils.toBoolean((String)p.getProperty(PROPERTY_PRIVILEGED, p.getProperty(PROPERTY_LEGACY_PRIVILEGED, Boolean.FALSE.toString()))));
        String overrideString = p.getProperty(PROPERTY_LOADER_OVERRIDE);
        if (StringUtils.isNotBlank((String)overrideString)) {
            HashSet<String> values = new HashSet<String>();
            String[] overrides = overrideString.split(",");
            Collections.addAll(values, overrides);
            d.setLoaderOverride(values);
        }
        return d;
    }

    @Override
    public String getSupportedFormat() {
        return "properties";
    }
}

