/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.application;

import java.io.IOException;
import java.util.Map;
import org.mule.MuleCoreExtension;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.application.ApplicationWrapper;
import org.mule.module.launcher.application.DefaultApplicationFactory;
import org.mule.module.launcher.application.PriviledgedMuleApplication;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;

public class PrivilegedApplicationFactory
extends DefaultApplicationFactory {
    private final DeploymentService deploymentService;
    private final Map<Class<? extends MuleCoreExtension>, MuleCoreExtension> coreExtensions;

    public PrivilegedApplicationFactory(DeploymentService deploymentService, Map<Class<? extends MuleCoreExtension>, MuleCoreExtension> coreExtensions) {
        this.deploymentService = deploymentService;
        this.coreExtensions = coreExtensions;
    }

    @Override
    protected Application createAppFrom(ApplicationDescriptor descriptor) throws IOException {
        if (descriptor.isPrivileged()) {
            return this.createPriviledgedApp(descriptor);
        }
        return super.createAppFrom(descriptor);
    }

    protected Application createPriviledgedApp(ApplicationDescriptor descriptor) throws IOException {
        PriviledgedMuleApplication delegate = new PriviledgedMuleApplication(descriptor);
        if (this.deploymentListener != null) {
            delegate.setDeploymentListener(this.deploymentListener);
        }
        delegate.setDeploymentService(this.deploymentService);
        delegate.setCoreExtensions(this.coreExtensions);
        return new ApplicationWrapper(delegate);
    }
}

