/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.config.builders.AutoConfigurationBuilder;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.NotificationException;
import org.mule.module.launcher.AbstractFileWatcher;
import org.mule.module.launcher.ApplicationMuleContextBuilder;
import org.mule.module.launcher.ConfigChangeMonitorThreadFactory;
import org.mule.module.launcher.DefaultAppBloodhound;
import org.mule.module.launcher.DefaultMuleSharedDomainClassLoader;
import org.mule.module.launcher.DeploymentInitException;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.DeploymentStartException;
import org.mule.module.launcher.DeploymentStopException;
import org.mule.module.launcher.GoodCitizenClassLoader;
import org.mule.module.launcher.InstallException;
import org.mule.module.launcher.MuleApplicationClassLoader;
import org.mule.module.launcher.MuleSharedDomainClassLoader;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.ClassUtils;
import org.mule.util.ExceptionUtils;
import org.mule.util.FileUtils;
import org.mule.util.SplashScreen;
import org.mule.util.StringUtils;

public class DefaultMuleApplication
implements Application {
    protected static final int DEFAULT_RELOAD_CHECK_INTERVAL_MS = 3000;
    protected static final String ANCHOR_FILE_BLURB = "Delete this file while Mule is running to undeploy this app in a clean way.";
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected final transient Log deployLogger = LogFactory.getLog(DeploymentService.class);
    protected ScheduledExecutorService watchTimer;
    private String appName;
    private MuleContext muleContext;
    private ClassLoader deploymentClassLoader;
    private ApplicationDescriptor descriptor;
    protected String[] absoluteResourcePaths;

    protected DefaultMuleApplication(String appName) {
        this.appName = appName;
    }

    public void install() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("New app '%s'", this.appName)));
        }
        DefaultAppBloodhound bh = new DefaultAppBloodhound();
        try {
            this.descriptor = bh.fetch(this.getAppName());
        }
        catch (IOException e) {
            throw new InstallException(MessageFactory.createStaticMessage((String)"Failed to parse the application deployment descriptor"), e);
        }
        String[] configResources = this.descriptor.getConfigResources();
        this.absoluteResourcePaths = new String[configResources.length];
        for (int i = 0; i < configResources.length; ++i) {
            String resource = configResources[i];
            File file = this.toAbsoluteFile(resource);
            if (!file.exists()) {
                throw new InstallException(MessageFactory.createStaticMessage((String)String.format("Config for app '%s' not found: %s", this.getAppName(), file)));
            }
            this.absoluteResourcePaths[i] = file.getAbsolutePath();
        }
        this.createDeploymentClassLoader();
    }

    public String getAppName() {
        return this.appName;
    }

    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Starting app '%s'", this.appName)));
        }
        try {
            this.muleContext.start();
            File marker = new File(MuleContainerBootstrapUtils.getMuleAppsDir(), String.format("%s-anchor.txt", this.getAppName()));
            FileUtils.writeStringToFile((File)marker, (String)ANCHOR_FILE_BLURB);
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(null);
                this.deployLogger.info((Object)SplashScreen.miniSplash((String)String.format("Started app '%s'", this.appName)));
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        catch (MuleException e) {
            this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
            throw new DeploymentStartException(CoreMessages.createStaticMessage((String)ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
        catch (IOException e) {
            this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
            throw new DeploymentStartException(CoreMessages.createStaticMessage((String)ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    public void init() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Initializing app '%s'", this.appName)));
        }
        String configBuilderClassName = null;
        try {
            String builderFromDesc = this.descriptor.getConfigurationBuilder();
            configBuilderClassName = "spring".equalsIgnoreCase(builderFromDesc) ? "org.mule.config.spring.SpringXmlConfigurationBuilder" : (builderFromDesc == null ? AutoConfigurationBuilder.class.getName() : builderFromDesc);
            ConfigurationBuilder cfgBuilder = (ConfigurationBuilder)ClassUtils.instanciateClass((String)configBuilderClassName, (Object[])new Object[]{this.absoluteResourcePaths}, (ClassLoader)this.getDeploymentClassLoader());
            if (!cfgBuilder.isConfigured()) {
                ArrayList<Object> builders = new ArrayList<Object>(2);
                Map<String, String> appProperties = this.descriptor.getAppProperties();
                appProperties.put("app.home", new File(MuleContainerBootstrapUtils.getMuleAppsDir(), this.getAppName()).getAbsolutePath());
                appProperties.put("app.name", this.getAppName());
                builders.add(new SimpleConfigurationBuilder(appProperties));
                if (ClassUtils.isClassOnPath((String)"org.mule.config.AnnotationsConfigurationBuilder", this.getClass())) {
                    Object configBuilder = ClassUtils.instanciateClass((String)"org.mule.config.AnnotationsConfigurationBuilder", (Object[])ClassUtils.NO_ARGS, this.getClass());
                    builders.add((ConfigurationBuilder)configBuilder);
                }
                builders.add(cfgBuilder);
                DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
                this.muleContext = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)new ApplicationMuleContextBuilder(this.descriptor));
                if (this.descriptor.isRedeploymentEnabled()) {
                    this.createRedeployMonitor();
                }
            }
        }
        catch (Exception e) {
            this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
            throw new DeploymentInitException(CoreMessages.createStaticMessage((String)ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public ClassLoader getDeploymentClassLoader() {
        return this.deploymentClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            ClassLoader appCl = this.getDeploymentClassLoader();
            if (appCl != null) {
                Thread.currentThread().setContextClassLoader(appCl);
            }
            this.doDispose();
            if (appCl != null && appCl instanceof GoodCitizenClassLoader) {
                GoodCitizenClassLoader classLoader = (GoodCitizenClassLoader)appCl;
                classLoader.close();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(null);
        }
    }

    public void redeploy() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Redeploying app '%s'", this.appName)));
        }
        this.dispose();
        this.install();
        ClassLoader cl = this.getDeploymentClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        this.init();
        this.start();
        Thread.currentThread().setContextClassLoader(null);
    }

    public void stop() {
        if (this.muleContext == null) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Stopping app '%s'", this.appName)));
        }
        try {
            this.muleContext.stop();
        }
        catch (MuleException e) {
            throw new DeploymentStopException(MessageFactory.createStaticMessage((String)this.appName), e);
        }
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), this.appName, Integer.toHexString(System.identityHashCode(this)));
    }

    protected void doDispose() {
        if (this.muleContext == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)String.format("App '%s' never started, nothing to dispose of", this.appName));
            }
            return;
        }
        if (this.muleContext.isStarted() && !this.muleContext.isDisposed()) {
            try {
                this.stop();
            }
            catch (DeploymentStopException e) {
                this.logger.error((Object)e);
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Disposing app '%s'", this.appName)));
        }
        this.muleContext.dispose();
        this.muleContext = null;
    }

    protected void createDeploymentClassLoader() {
        String domain = this.descriptor.getDomain();
        MuleSharedDomainClassLoader parent = StringUtils.isBlank((String)domain) || "default".equals(domain) ? new DefaultMuleSharedDomainClassLoader(this.getClass().getClassLoader()) : new MuleSharedDomainClassLoader(domain, this.getClass().getClassLoader());
        this.deploymentClassLoader = new MuleApplicationClassLoader(this.appName, (ClassLoader)parent);
    }

    protected void createRedeployMonitor() throws NotificationException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Monitoring for hot-deployment: " + new File(this.absoluteResourcePaths[0])));
        }
        final ConfigFileWatcher watcher = new ConfigFileWatcher(new File(this.absoluteResourcePaths[0]));
        this.muleContext.registerListener((ServerNotificationListener)new MuleContextNotificationListener<MuleContextNotification>(){

            public void onNotification(MuleContextNotification notification) {
                int action = notification.getAction();
                switch (action) {
                    case 104: {
                        DefaultMuleApplication.this.scheduleConfigMonitor(watcher);
                        break;
                    }
                    case 105: {
                        if (DefaultMuleApplication.this.watchTimer != null) {
                            DefaultMuleApplication.this.watchTimer.shutdownNow();
                        }
                        DefaultMuleApplication.this.muleContext.unregisterListener((ServerNotificationListener)this);
                    }
                }
            }
        });
    }

    protected void scheduleConfigMonitor(AbstractFileWatcher watcher) {
        int reloadIntervalMs = 3000;
        this.watchTimer = Executors.newSingleThreadScheduledExecutor(new ConfigChangeMonitorThreadFactory(this.appName));
        this.watchTimer.scheduleWithFixedDelay(watcher, 3000L, 3000L, TimeUnit.MILLISECONDS);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Reload interval: 3000");
        }
    }

    protected File toAbsoluteFile(String path) {
        String muleHome = System.getProperty("mule.home");
        String configPath = String.format("%s/apps/%s/%s", muleHome, this.getAppName(), path);
        return new File(configPath);
    }

    protected class ConfigFileWatcher
    extends AbstractFileWatcher {
        public ConfigFileWatcher(File watchedResource) {
            super(watchedResource);
        }

        protected synchronized void onChange(File file) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("================== Reloading " + file));
            }
            ClassLoader cl = DefaultMuleApplication.this.getDeploymentClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            DefaultMuleApplication.this.redeploy();
        }
    }
}

