/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transport.OutputHandler;
import org.mule.module.jersey.JerseyResourcesComponent;

public class MuleResponseWriter
implements ContainerResponseWriter {
    private ByteArrayOutputStream out;
    private OutputHandler output;
    private final MuleMessage message;

    public MuleResponseWriter(MuleMessage request) {
        this.message = request;
        this.out = new ByteArrayOutputStream();
        this.output = new OutputHandler(){

            public void write(MuleEvent arg0, OutputStream realOut) throws IOException {
                realOut.write(MuleResponseWriter.this.out.toByteArray());
                realOut.flush();
            }
        };
    }

    public OutputStream writeStatusAndHeaders(long x, ContainerResponse response) throws IOException {
        HashMap customHeaders = new HashMap();
        for (Map.Entry e : response.getHttpHeaders().entrySet()) {
            this.message.setOutboundProperty((String)e.getKey(), (Object)this.getHeaderValue((List)e.getValue()));
        }
        this.message.setInvocationProperty(JerseyResourcesComponent.JERSEY_RESPONSE, (Object)response);
        this.message.setOutboundProperty("http.status", (Object)response.getStatus());
        return this.out;
    }

    private String getHeaderValue(List<Object> values) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object o : values) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(ContainerResponse.getHeaderValue((Object)o));
        }
        return sb.toString();
    }

    public void finish() throws IOException {
    }

    public OutputHandler getResponse() {
        return this.output;
    }
}

