/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.jaas.loginmodule;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class DefaultLoginModule
implements LoginModule {
    private CallbackHandler callbackHandler;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private String password;
    private String credentials;
    private List credentialList;

    public final boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                this.password = null;
            }
        } else {
            this.logout();
        }
        return true;
    }

    public final boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.username = null;
        this.password = null;
        this.commitSucceeded = true;
        return true;
    }

    public final void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.callbackHandler = callbackHandler;
        this.credentials = (String)options.get("credentials");
        this.credentialList = this.getCredentialList(this.credentials);
    }

    public final boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        if (this.callbackHandler == null) {
            throw new LoginException("no handler");
        }
        NameCallback nameCb = new NameCallback("user: ");
        PasswordCallback passCb = new PasswordCallback("password: ", true);
        Callback[] callbacks = new Callback[]{nameCb, passCb};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException("Error: " + e.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        this.username = nameCb.getName();
        this.password = new String(passCb.getPassword());
        boolean usernameCorrect = false;
        boolean passwordCorrect = false;
        this.succeeded = false;
        for (int i = 0; i < this.credentialList.size(); i += 2) {
            usernameCorrect = this.username.equals(this.credentialList.get(i).toString());
            if (!(usernameCorrect & (passwordCorrect = this.password.equals(this.credentialList.get(i + 1).toString())))) continue;
            this.succeeded = true;
        }
        if (this.succeeded) {
            return true;
        }
        this.succeeded = false;
        this.username = null;
        this.password = null;
        if (!usernameCorrect) {
            throw new FailedLoginException("User Name Incorrect");
        }
        throw new FailedLoginException("Password Incorrect");
    }

    public final boolean logout() {
        return this.succeeded;
    }

    public final List getCredentialList(String credentials) {
        boolean semicolonIsFound = false;
        boolean dividerIsFound = false;
        char[] credentialArray = credentials.toCharArray();
        String username = "";
        String password = "";
        Vector<String> outputList = new Vector<String>();
        for (int i = 0; i < credentials.length(); ++i) {
            if (credentialArray[i] != ':' && !dividerIsFound) {
                username = username + credentialArray[i];
                continue;
            }
            if (credentialArray[i] == ':' && !dividerIsFound) {
                dividerIsFound = true;
                continue;
            }
            if (credentialArray[i] != ';' && !semicolonIsFound && dividerIsFound) {
                password = password + credentialArray[i];
                continue;
            }
            if (credentialArray[i] != ';' && !semicolonIsFound && dividerIsFound) {
                password = password + credentialArray[i];
                continue;
            }
            if (credentialArray[i] != ';' || semicolonIsFound || !dividerIsFound) continue;
            outputList.add(username);
            outputList.add(password);
            semicolonIsFound = false;
            dividerIsFound = false;
            username = "";
            password = "";
        }
        return outputList;
    }
}

