/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.guice;

import com.google.inject.AbstractModule;
import com.google.inject.MembersInjector;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.ProviderMethod;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.NamedObject;
import org.mule.api.agent.Agent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;

public class MuleSupportModule
extends AbstractModule {
    protected MuleContext muleContext;

    public MuleSupportModule(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    protected final void configure() {
        this.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> iTypeLiteral, TypeEncounter<I> iTypeEncounter) {
                iTypeEncounter.register(new MuleContextAwareInjector());
                iTypeEncounter.register(new MuleBindInjector());
            }
        });
        this.bind(MuleContext.class).toInstance((Object)this.muleContext);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MuleBindInjector<I>
    implements InjectionListener<I> {
        MuleBindInjector() {
        }

        public void afterInjection(I i) {
            if (i instanceof ProviderMethod) {
                Class type = ((ProviderMethod)i).getKey().getTypeLiteral().getRawType();
                boolean bindRequired = type.equals(Connector.class) || type.equals(Agent.class);
                Named bindTo = ((ProviderMethod)i).getMethod().getAnnotation(Named.class);
                if (bindTo != null) {
                    try {
                        Object o = ((ProviderMethod)i).get();
                        if (o instanceof NamedObject) {
                            ((NamedObject)o).setName(bindTo.value());
                        }
                        MuleSupportModule.this.muleContext.getRegistry().registerObject(bindTo.value(), o);
                    }
                    catch (RegistrationException e) {
                        throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)("failed to bind " + bindTo.value())));
                    }
                } else if (bindRequired) {
                    throw new RuntimeException("Provider object type: " + type + ", must have a @Named annotation so that the object can be bound in Mule");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MuleContextAwareInjector<I>
    implements MembersInjector<I> {
        MuleContextAwareInjector() {
        }

        public void injectMembers(I o) {
            if (o instanceof MuleContextAware) {
                ((MuleContextAware)o).setMuleContext(MuleSupportModule.this.muleContext);
            }
        }
    }
}

