/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.util;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.mule.extension.introspection.Capable;
import org.mule.util.Preconditions;

public class CapabilityUtils {
    private CapabilityUtils() {
    }

    public static <T> Set<T> getCapabilities(Set<?> capabilities, Class<T> capabilityType) {
        ImmutableSet.Builder matches = ImmutableSet.builder();
        for (Object capability : capabilities) {
            if (!capabilityType.isInstance(capability)) continue;
            matches.add(capability);
        }
        return matches.build();
    }

    public static boolean isCapableOf(Set<?> capabilities, Class<?> capabilityType) {
        return !CapabilityUtils.getCapabilities(capabilities, capabilityType).isEmpty();
    }

    public static <T> T getSingleCapability(Capable capable, Class<T> capabilityType) {
        Set capabilities = capable.getCapabilities(capabilityType);
        if (CollectionUtils.isEmpty((Collection)capabilities)) {
            return null;
        }
        Preconditions.checkArgument((capabilities.size() == 1 ? 1 : 0) != 0, (String)String.format("One instance of capability %s was expected but %d found instead", capabilityType.getName(), capabilities.size()));
        return (T)capabilities.iterator().next();
    }

    public static <T> T getSingleCapability(Set<?> capabilities, Class<T> capabilityType) {
        if (CollectionUtils.isEmpty(capabilities)) {
            return null;
        }
        for (Object capability : capabilities) {
            if (!capabilityType.isInstance(capability)) continue;
            return (T)capability;
        }
        return null;
    }
}

