/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.resolver;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.extension.runtime.OperationContext;
import org.mule.module.extension.internal.runtime.resolver.ArgumentResolver;
import org.mule.module.extension.internal.util.IntrospectionUtils;

public final class ParameterGroupArgumentResolver<T>
implements ArgumentResolver<T> {
    private final Class<T> type;
    private final Collection<Field> parameterFields;
    private final Map<Field, ParameterGroupArgumentResolver<?>> childGroups;

    public ParameterGroupArgumentResolver(Class<T> type) {
        IntrospectionUtils.checkInstantiable(type);
        this.type = type;
        this.parameterFields = IntrospectionUtils.getParameterFields(type);
        for (Field parameterField : this.parameterFields) {
            parameterField.setAccessible(true);
        }
        this.childGroups = new HashMap();
        for (Field groupField : IntrospectionUtils.getParameterGroupFields(type)) {
            groupField.setAccessible(true);
            this.childGroups.put(groupField, new ParameterGroupArgumentResolver(groupField.getType()));
        }
    }

    @Override
    public T resolve(OperationContext operationContext) {
        try {
            T group = this.type.newInstance();
            for (Field field : this.parameterFields) {
                Object value = operationContext.getParameterValue(IntrospectionUtils.getAlias(field));
                if (value == null) continue;
                field.set(group, value);
            }
            for (Map.Entry entry : this.childGroups.entrySet()) {
                ((Field)entry.getKey()).set(group, ((ParameterGroupArgumentResolver)entry.getValue()).resolve(operationContext));
            }
            return group;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Could not create parameter group"), (Throwable)e);
        }
    }
}

