/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.config;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.extension.introspection.DataQualifier;
import org.mule.extension.introspection.DataQualifierVisitor;
import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.Parameter;
import org.mule.module.extension.internal.config.ElementDescriptor;
import org.mule.module.extension.internal.introspection.AbstractDataQualifierVisitor;
import org.mule.module.extension.internal.introspection.SimpleTypeDataQualifierVisitor;
import org.mule.module.extension.internal.runtime.DefaultObjectBuilder;
import org.mule.module.extension.internal.runtime.ObjectBuilder;
import org.mule.module.extension.internal.runtime.resolver.CachingValueResolverWrapper;
import org.mule.module.extension.internal.runtime.resolver.CollectionValueResolver;
import org.mule.module.extension.internal.runtime.resolver.NestedProcessorValueResolver;
import org.mule.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.module.extension.internal.runtime.resolver.RegistryLookupValueResolver;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.module.extension.internal.util.IntrospectionUtils;
import org.mule.module.extension.internal.util.NameUtils;
import org.mule.util.TemplateParser;
import org.mule.util.ValueHolder;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

final class XmlExtensionParserUtils {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss";
    private static final String CALENDAR_FORMAT = "yyyy-MM-dd'T'hh:mm:ssX";
    private static final TemplateParser parser = TemplateParser.createMuleStyleParser();
    private static final ConversionService conversionService = new DefaultConversionService();

    XmlExtensionParserUtils() {
    }

    static void parseConfigName(Element element, BeanDefinitionBuilder builder) {
        String name = AutoIdUtils.getUniqueName((Element)element, (String)"mule-bean");
        element.setAttribute("name", name);
        builder.addConstructorArgValue((Object)name);
    }

    static void setNoRecurseOnDefinition(BeanDefinition definition) {
        definition.setAttribute("org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE", (Object)Boolean.TRUE);
    }

    static ValueResolver parseParameter(ElementDescriptor element, Parameter parameter) {
        return XmlExtensionParserUtils.parseElement(element, parameter.getName(), parameter.getType(), parameter.getDefaultValue());
    }

    static ValueResolver parseElement(final ElementDescriptor element, final String fieldName, final DataType dataType, final Object defaultValue) {
        final String hyphenizedFieldName = NameUtils.hyphenize((String)fieldName);
        final String singularName = NameUtils.singularize((String)hyphenizedFieldName);
        final ValueHolder resolverReference = new ValueHolder();
        AbstractDataQualifierVisitor visitor = new AbstractDataQualifierVisitor(){

            public void defaultOperation() {
                resolverReference.set((Object)XmlExtensionParserUtils.getResolverFromValue(XmlExtensionParserUtils.getAttributeValue(element, fieldName, defaultValue), dataType));
            }

            public void onList() {
                resolverReference.set((Object)XmlExtensionParserUtils.parseCollection(element, fieldName, hyphenizedFieldName, singularName, defaultValue, dataType));
            }

            public void onPojo() {
                resolverReference.set((Object)XmlExtensionParserUtils.parsePojo(element, fieldName, hyphenizedFieldName, dataType, defaultValue));
            }

            public void onDateTime() {
                if (Calendar.class.isAssignableFrom(dataType.getRawType())) {
                    resolverReference.set((Object)XmlExtensionParserUtils.parseCalendar(element, fieldName, dataType, defaultValue));
                } else {
                    resolverReference.set((Object)XmlExtensionParserUtils.parseDate(element, fieldName, dataType, defaultValue));
                }
            }
        };
        dataType.getQualifier().accept((DataQualifierVisitor)visitor);
        return (ValueResolver)resolverReference.get();
    }

    static BeanDefinition toElementDescriptorBeanDefinition(Element element) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ElementDescriptor.class);
        builder.addConstructorArgValue((Object)element.getLocalName());
        XmlExtensionParserUtils.parseElementDescriptorAttributes(element, builder);
        XmlExtensionParserUtils.parseElementDescriptorChilds(element, builder);
        return builder.getBeanDefinition();
    }

    static ResolverSet getResolverSet(ElementDescriptor element, List<Parameter> parameters) {
        return XmlExtensionParserUtils.getResolverSet(element, parameters, (Map<String, List<MessageProcessor>>)ImmutableMap.of());
    }

    static ResolverSet getResolverSet(ElementDescriptor element, List<Parameter> parameters, Map<String, List<MessageProcessor>> nestedOperations) {
        ResolverSet resolverSet = new ResolverSet();
        for (Parameter parameter : parameters) {
            List<MessageProcessor> nestedProcessors = nestedOperations.get(parameter.getName());
            if (!CollectionUtils.isEmpty(nestedProcessors)) {
                XmlExtensionParserUtils.addNestedProcessorResolver(resolverSet, parameter, nestedProcessors);
                continue;
            }
            ValueResolver resolver = XmlExtensionParserUtils.parseParameter(element, parameter);
            resolverSet.add(parameter, (ValueResolver)(resolver != null ? resolver : new StaticValueResolver(null)));
        }
        return resolverSet;
    }

    static Object getAttributeValue(ElementDescriptor element, String attributeName, Object defaultValue) {
        return element.hasAttribute(attributeName) ? element.getAttribute(attributeName) : defaultValue;
    }

    private static ValueResolver parseCollectionAsInnerElement(ElementDescriptor collectionElement, String childElementName, DataType collectionType) {
        final DataType itemsType = collectionType.getGenericTypes().length > 0 ? collectionType.getGenericTypes()[0] : DataType.of(Object.class);
        final LinkedList resolvers = new LinkedList();
        for (final ElementDescriptor item : collectionElement.getChildsByName(childElementName)) {
            AbstractDataQualifierVisitor visitor = new AbstractDataQualifierVisitor(){

                public void onPojo() {
                    resolvers.add(new ObjectBuilderValueResolver(XmlExtensionParserUtils.recursePojoProperties(itemsType.getRawType(), item)));
                }

                protected void defaultOperation() {
                    String value = item.getAttribute("value");
                    resolvers.add(XmlExtensionParserUtils.getResolverFromValue(value, itemsType));
                }
            };
            itemsType.getQualifier().accept((DataQualifierVisitor)visitor);
        }
        return CollectionValueResolver.of((Class)collectionType.getRawType(), resolvers);
    }

    private static ValueResolver parseCollection(ElementDescriptor element, String fieldName, String parentElementName, String childElementName, Object defaultValue, DataType collectionDataType) {
        Object resolver = XmlExtensionParserUtils.getResolverFromAttribute(element, fieldName, collectionDataType, defaultValue);
        if (resolver == null) {
            ElementDescriptor collectionElement = element.getChildByName(parentElementName);
            resolver = collectionElement != null ? XmlExtensionParserUtils.parseCollectionAsInnerElement(collectionElement, childElementName, collectionDataType) : new StaticValueResolver(defaultValue);
        }
        return resolver;
    }

    private static ValueResolver getResolverFromAttribute(ElementDescriptor element, String attributeName, DataType expectedDataType, Object defaultValue) {
        return XmlExtensionParserUtils.getResolverFromValue(XmlExtensionParserUtils.getAttributeValue(element, attributeName, defaultValue), expectedDataType);
    }

    private static ValueResolver getResolverFromValue(final Object value, final DataType expectedDataType) {
        if (XmlExtensionParserUtils.isExpression(value, parser)) {
            return new TypeSafeExpressionValueResolver((String)value, expectedDataType);
        }
        if (value != null) {
            final ValueHolder resolverValueHolder = new ValueHolder();
            SimpleTypeDataQualifierVisitor visitor = new SimpleTypeDataQualifierVisitor(){

                protected void onSimpleType() {
                    if (conversionService.canConvert(value.getClass(), expectedDataType.getRawType())) {
                        resolverValueHolder.set((Object)new StaticValueResolver(conversionService.convert(value, expectedDataType.getRawType())));
                    } else {
                        this.defaultOperation();
                    }
                }

                protected void defaultOperation() {
                    resolverValueHolder.set((Object)new CachingValueResolverWrapper((ValueResolver)new RegistryLookupValueResolver(value.toString())));
                }
            };
            expectedDataType.getQualifier().accept((DataQualifierVisitor)visitor);
            return (ValueResolver)resolverValueHolder.get();
        }
        return null;
    }

    private static ValueResolver parsePojo(ElementDescriptor element, String fieldName, String childElementName, DataType pojoType, Object defaultValue) {
        ValueResolver resolver = XmlExtensionParserUtils.getResolverFromAttribute(element, fieldName, pojoType, defaultValue);
        if (resolver != null) {
            return resolver;
        }
        ElementDescriptor childElement = element.getChildByName(childElementName);
        if (childElement != null) {
            return XmlExtensionParserUtils.getPojoValueResolver(pojoType, childElement);
        }
        if (NameUtils.getTopLevelTypeName((DataType)pojoType).equals(element.getName())) {
            return XmlExtensionParserUtils.getPojoValueResolver(pojoType, element);
        }
        return new StaticValueResolver(null);
    }

    private static ValueResolver getPojoValueResolver(DataType pojoType, ElementDescriptor element) {
        return new ObjectBuilderValueResolver(XmlExtensionParserUtils.recursePojoProperties(pojoType.getRawType(), element));
    }

    private static ObjectBuilder<Object> recursePojoProperties(Class<?> declaringClass, ElementDescriptor element) {
        DefaultObjectBuilder builder = new DefaultObjectBuilder(declaringClass);
        for (Field field : IntrospectionUtils.getParameterFields(declaringClass)) {
            ElementDescriptor childElement;
            DataType dataType;
            if (IntrospectionUtils.isIgnored((AccessibleObject)field)) continue;
            String parameterName = IntrospectionUtils.getAlias((Field)field);
            ValueResolver resolver = XmlExtensionParserUtils.getResolverFromAttribute(element, parameterName, dataType = IntrospectionUtils.getFieldDataType((Field)field), null);
            if (resolver == null && (childElement = element.getChildByName(parameterName = NameUtils.hyphenize((String)parameterName))) != null) {
                ObjectBuilder<Object> childBuilder = XmlExtensionParserUtils.recursePojoProperties(dataType.getRawType(), childElement);
                resolver = new ObjectBuilderValueResolver(childBuilder);
            }
            if (resolver == null) continue;
            builder.addPropertyResolver(field, resolver);
        }
        return builder;
    }

    private static Date doParseDate(ElementDescriptor element, String attributeName, String parseFormat, Object defaultValue) {
        Object value = XmlExtensionParserUtils.getAttributeValue(element, attributeName, defaultValue);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            SimpleDateFormat format = new SimpleDateFormat(parseFormat);
            try {
                return format.parse((String)value);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Could not transform value '%s' into a Date using pattern '%s'", value, parseFormat));
            }
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        throw new IllegalArgumentException(String.format("Could not transform value of type '%s' to Date", value != null ? value.getClass().getName() : "null"));
    }

    private static ValueResolver parseCalendar(ElementDescriptor element, String attributeName, DataType dataType, Object defaultValue) {
        Object value = XmlExtensionParserUtils.getAttributeValue(element, attributeName, defaultValue);
        if (XmlExtensionParserUtils.isExpression(value, parser)) {
            return new TypeSafeExpressionValueResolver((String)value, dataType);
        }
        Date date = XmlExtensionParserUtils.doParseDate(element, attributeName, CALENDAR_FORMAT, defaultValue);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new StaticValueResolver((Object)calendar);
    }

    private static ValueResolver parseDate(ElementDescriptor element, String attributeName, DataType dataType, Object defaultValue) {
        Object value = XmlExtensionParserUtils.getAttributeValue(element, attributeName, defaultValue);
        if (XmlExtensionParserUtils.isExpression(value, parser)) {
            return new TypeSafeExpressionValueResolver((String)value, dataType);
        }
        return new StaticValueResolver((Object)XmlExtensionParserUtils.doParseDate(element, attributeName, DATE_FORMAT, defaultValue));
    }

    private static void addNestedProcessorResolver(ResolverSet resolverSet, Parameter parameter, List<MessageProcessor> nestedProcessors) {
        ArrayList<NestedProcessorValueResolver> nestedProcessorResolvers = new ArrayList<NestedProcessorValueResolver>(nestedProcessors.size());
        for (MessageProcessor nestedProcessor : nestedProcessors) {
            nestedProcessorResolvers.add(new NestedProcessorValueResolver(nestedProcessor));
        }
        if (nestedProcessors.size() == 1 && parameter.getType().getQualifier() != DataQualifier.LIST) {
            resolverSet.add(parameter, (ValueResolver)new NestedProcessorValueResolver(nestedProcessors.get(0)));
        } else {
            resolverSet.add(parameter, (ValueResolver)CollectionValueResolver.of(ArrayList.class, nestedProcessorResolvers));
        }
    }

    private static void parseElementDescriptorChilds(Element element, BeanDefinitionBuilder builder) {
        ManagedList managedChilds = new ManagedList();
        for (Element child : DomUtils.getChildElements((Element)element)) {
            managedChilds.add((Object)XmlExtensionParserUtils.toElementDescriptorBeanDefinition(child));
        }
        builder.addConstructorArgValue((Object)managedChilds);
    }

    private static void parseElementDescriptorAttributes(Element element, BeanDefinitionBuilder builder) {
        ManagedMap managedAttributes = new ManagedMap();
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.item(i).getLocalName();
            managedAttributes.put((Object)name, (Object)element.getAttribute(name));
        }
        builder.addConstructorArgValue((Object)managedAttributes);
    }

    private static boolean isExpression(Object value, TemplateParser parser) {
        if (value instanceof String) {
            return parser.isContainsTemplate((String)value);
        }
        return false;
    }
}

