/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.callback.SourceCallback;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.processor.MessageProcessorContainer;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.util.NotificationUtils;

public abstract class AbstractListeningMessageProcessor
extends DevkitBasedMessageProcessor
implements SourceCallback,
MessageProcessorContainer {
    private MessageProcessor messageProcessor;

    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }

    public AbstractListeningMessageProcessor(String operationName) {
        super(operationName);
    }

    public void setListener(MessageProcessor listener) {
        this.messageProcessor = listener;
    }

    @Override
    public Object process(Object message) throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage(message, this.getMuleContext());
        DefaultMuleEvent muleEvent = new DefaultMuleEvent((MuleMessage)muleMessage, MessageExchangePattern.ONE_WAY, this.getFlowConstruct());
        MuleEvent responseEvent = this.processEvent((MuleEvent)muleEvent);
        if (responseEvent != null && responseEvent.getMessage() != null) {
            return responseEvent.getMessage().getPayload();
        }
        return null;
    }

    @Override
    public Object process(Object message, Map<String, Object> properties) throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage(message, properties, null, null, this.getMuleContext());
        DefaultMuleEvent muleEvent = new DefaultMuleEvent((MuleMessage)muleMessage, MessageExchangePattern.ONE_WAY, this.getFlowConstruct());
        MuleEvent responseEvent = this.processEvent((MuleEvent)muleEvent);
        if (responseEvent != null && responseEvent.getMessage() != null) {
            return responseEvent.getMessage().getPayload();
        }
        return null;
    }

    @Override
    public Object process() throws Exception {
        MuleEvent responseEvent = this.processEvent(RequestContext.getEvent());
        if (responseEvent != null && responseEvent.getMessage() != null) {
            return responseEvent.getMessage().getPayload();
        }
        return null;
    }

    @Override
    public MuleEvent processEvent(MuleEvent event) throws MuleException {
        return this.messageProcessor != null ? this.messageProcessor.process(event) : event;
    }

    @Override
    protected MuleEvent doProcess(MuleEvent event) throws Exception {
        throw new UnsupportedOperationException("Listening message processors cannot execute this method");
    }

    public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
        if (this.messageProcessor instanceof MessageProcessorChain) {
            NotificationUtils.addMessageProcessorPathElements((List)((MessageProcessorChain)this.messageProcessor).getMessageProcessors(), (MessageProcessorPathElement)pathElement.getParent());
        } else if (this.messageProcessor != null) {
            NotificationUtils.addMessageProcessorPathElements(Arrays.asList(this.messageProcessor), (MessageProcessorPathElement)pathElement.getParent());
        }
    }
}

