/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.type;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.mule.module.db.internal.domain.type.ResolvedDbType;
import org.mule.util.IOUtils;

public class BlobResolvedDataType
extends ResolvedDbType {
    public BlobResolvedDataType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value) throws SQLException {
        if (value != null && !(value instanceof Blob)) {
            Blob blob = statement.getConnection().createBlob();
            if (value instanceof byte[]) {
                blob.setBytes(1L, (byte[])value);
            } else if (value instanceof InputStream) {
                blob.setBytes(1L, IOUtils.toByteArray((InputStream)((InputStream)value)));
            } else {
                throw new IllegalArgumentException(BlobResolvedDataType.createUnsupportedTypeErrorMessage(value));
            }
            value = blob;
        }
        super.setParameterValue(statement, index, value);
    }

    protected static String createUnsupportedTypeErrorMessage(Object value) {
        return String.format("Cannot create a Blob from a value of type '%s'", value.getClass());
    }
}

