/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.database;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.connection.DbConnectionFactory;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.domain.type.DbTypeManager;

public class GenericDbConfig
implements DbConfig {
    private final DataSource dataSource;
    private final String name;
    private final DbConnectionFactory dbConnectionFactory;
    private final DbTypeManager dbTypeManager;

    public GenericDbConfig(DataSource dataSource, String name, DbTypeManager dbTypeManager, DbConnectionFactory dbConnectionFactory) {
        this.name = name;
        this.dataSource = dataSource;
        this.dbTypeManager = dbTypeManager;
        this.dbConnectionFactory = dbConnectionFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public DbConnectionFactory getConnectionFactory() {
        return this.dbConnectionFactory;
    }

    public DbTypeManager getDbTypeManager() {
        return this.dbTypeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        DbConnection connection = null;
        try {
            connection = this.dbConnectionFactory.createConnection(TransactionalAction.NOT_SUPPORTED);
            DefaultTestResult defaultTestResult = new DefaultTestResult(Result.Status.SUCCESS);
            return defaultTestResult;
        }
        catch (SQLException e) {
            DefaultTestResult defaultTestResult = new DefaultTestResult(Result.Status.FAILURE, e.getMessage());
            return defaultTestResult;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public Result<List<MetaDataKey>> getMetaDataKeys() {
        ArrayList keys = new ArrayList();
        return new DefaultResult(keys, Result.Status.SUCCESS, "Successfully obtained metadata");
    }

    public Result<MetaData> getMetaData(MetaDataKey metaDataKey) {
        return new DefaultResult(null, Result.Status.SUCCESS, "No metadata obtained");
    }
}

