/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.type;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.DbTypeManager;
import org.mule.module.db.internal.domain.type.JdbcTypes;
import org.mule.module.db.internal.domain.type.ResolvedDbType;
import org.mule.module.db.internal.domain.type.UnknownDbType;
import org.mule.module.db.internal.domain.type.UnknownDbTypeException;
import org.mule.module.db.internal.result.resultset.ResultSetIterator;
import org.mule.module.db.internal.result.resultset.SingleResultResultSetCloser;
import org.mule.module.db.internal.result.row.InsensitiveMapRowHandler;

public class MetadataDbTypeManager
implements DbTypeManager {
    static final String METADATA_TYPE_ID_COLUMN = "DATA_TYPE";
    static final String METADATA_TYPE_NAME_COLUMN = "TYPE_NAME";
    private final Log logger = LogFactory.getLog(MetadataDbTypeManager.class);
    private final Map<String, DbType> typesById = new HashMap<String, DbType>();
    private final Object lock = new Object();
    private boolean initialised;

    protected void registerType(DbType dbType) {
        String typeKey = dbType.getName() + dbType.getId();
        if (this.typesById.containsKey(typeKey)) {
            throw new IllegalArgumentException(String.format("There is already a registered type with ID %s and name %s", dbType.getId(), dbType.getName()));
        }
        this.typesById.put(typeKey, dbType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbType lookup(DbConnection connection, int id, String name) throws UnknownDbTypeException {
        String typeKey;
        if (!this.initialised) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.initialised) {
                    this.initialise(connection);
                    this.initialised = true;
                }
            }
        }
        if (this.typesById.containsKey(typeKey = name + id)) {
            return this.typesById.get(typeKey);
        }
        if (id == 1111) {
            return UnknownDbType.getInstance();
        }
        throw new UnknownDbTypeException(id, name);
    }

    @Override
    public DbType lookup(DbConnection connection, String name) throws UnknownDbTypeException {
        throw new UnknownDbTypeException(name);
    }

    protected void initialise(DbConnection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet typeInfo = metaData.getTypeInfo();
            ResultSetIterator resultSetIterator = new ResultSetIterator(connection, typeInfo, new InsensitiveMapRowHandler(), new SingleResultResultSetCloser());
            while (resultSetIterator.hasNext()) {
                Object typeRecord = resultSetIterator.next();
                Number data_type = (Number)typeRecord.get(METADATA_TYPE_ID_COLUMN);
                String type_name = (String)typeRecord.get(METADATA_TYPE_NAME_COLUMN);
                ResolvedDbType resolvedDbType = new ResolvedDbType(data_type.intValue(), type_name);
                if (this.isUserDefinedType(resolvedDbType)) continue;
                this.registerType(resolvedDbType);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Type: " + typeRecord));
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cannot process metadata information", e);
        }
    }

    private boolean isUserDefinedType(DbType dbType) {
        return this.isTypeDerivedFrom(dbType, JdbcTypes.STRUCT_DB_TYPE) || this.isTypeDerivedFrom(dbType, JdbcTypes.DISTINCT_DB_TYPE) || this.isTypeDerivedFrom(dbType, JdbcTypes.ARRAY_DB_TYPE);
    }

    private boolean isTypeDerivedFrom(DbType type, DbType baseType) {
        return type.getId() == baseType.getId() && !type.getName().equals(baseType.getName());
    }
}

