/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.processor;

import org.mule.config.spring.parsers.AbstractHierarchicalDefinitionParser;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.module.db.internal.config.resolver.database.DefaultDbConfigResolverFactoryBean;
import org.mule.module.db.internal.domain.statement.QueryStatementFactory;
import org.mule.module.db.internal.resolver.database.StaticDbConfigResolver;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractDbProcessorDefinitionParser
extends AbstractHierarchicalDefinitionParser {
    public static final String LIST_SEPARATOR = ",";
    public static final String CONFIG_PROPERTY = "config-ref";
    public static final String MAX_ROWS_ATTRIBUTE = "maxRows";
    public static final String FETCH_SIZE = "fetchSize";
    public static final String STREAMING_ATTRIBUTE = "streaming";
    public static final int DEFAULT_FETCH_SIZE = 10;
    protected BeanDefinition dbConfigResolverFactoryBeanDefinition;
    protected boolean streaming;

    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        builder.setScope(this.isSingleton() ? "singleton" : "prototype");
        this.doParseElement(element, context, builder);
        BeanAssembler assembler = this.getBeanAssembler(element, builder);
        assembler.insertBeanInTarget("messageProcessor");
    }

    protected abstract void doParseElement(Element var1, ParserContext var2, BeanDefinitionBuilder var3);

    protected void parseConfig(Element element, BeanDefinitionBuilder builder) {
        BeanDefinitionBuilder wrapper;
        String config = element.getAttribute(CONFIG_PROPERTY);
        if ("".equals(config)) {
            wrapper = BeanDefinitionBuilder.genericBeanDefinition(DefaultDbConfigResolverFactoryBean.class);
        } else {
            wrapper = BeanDefinitionBuilder.genericBeanDefinition(StaticDbConfigResolver.class);
            wrapper.addConstructorArgReference(config);
        }
        this.dbConfigResolverFactoryBeanDefinition = wrapper.getBeanDefinition();
        builder.addConstructorArgValue((Object)this.dbConfigResolverFactoryBeanDefinition);
    }

    protected void parseSourceExpression(Element element, BeanDefinitionBuilder builder) {
        builder.addPropertyValue("source", (Object)element.getAttribute("source"));
    }

    protected void parseTargetExpression(Element element, BeanDefinitionBuilder builder) {
        builder.addPropertyValue("target", (Object)element.getAttribute("target"));
    }

    protected Object parseStatementFactory(Element element) {
        QueryStatementFactory defaultStatementFactory = new QueryStatementFactory();
        if (element.hasAttribute(MAX_ROWS_ATTRIBUTE)) {
            defaultStatementFactory.setMaxRows(Integer.parseInt(element.getAttribute(MAX_ROWS_ATTRIBUTE)));
        }
        if (element.hasAttribute(FETCH_SIZE)) {
            defaultStatementFactory.setFetchSize(Integer.parseInt(element.getAttribute(FETCH_SIZE)));
        } else if (this.streaming) {
            this.logger.warn((Object)"Streaming mode needs to configure fetchSize property. Using default value: 10");
            defaultStatementFactory.setFetchSize(10);
        }
        return defaultStatementFactory;
    }

    protected void processStreamingAttribute(BeanDefinitionBuilder builder, String streamingValue) {
        if (!StringUtils.isEmpty((String)streamingValue)) {
            this.streaming = Boolean.parseBoolean(streamingValue);
        }
    }
}

