/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.module.db.internal.config.domain.param.AbstractParamDefinitionDefinitionParser;
import org.mule.module.db.internal.config.domain.param.InOutParamDefinitionDefinitionParser;
import org.mule.module.db.internal.config.domain.param.InputParamDefinitionDefinitionParser;
import org.mule.module.db.internal.config.domain.param.InputParamValueBeanDefinitionParser;
import org.mule.module.db.internal.config.domain.param.OutputParamDefinitionDefinitionParser;
import org.mule.module.db.internal.config.domain.query.DynamicQueryTemplateFactoryBean;
import org.mule.module.db.internal.config.domain.query.ParameterizedQueryTemplateFactoryBean;
import org.mule.module.db.internal.config.domain.query.QueryTemplateFactoryBean;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.parser.SimpleQueryTemplateParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class QueryDefinitionParser {
    public static final String PARAMETERIZED_QUERY = "parameterized-query";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String TEMPLATE_QUERY_REF = "template-query-ref";
    public static final String DYNAMIC_QUERY = "dynamic-query";
    public static final String[] QUERY_TAG_NAMES = new String[]{"parameterized-query", "template-query-ref", "dynamic-query"};
    public static final String IN_PARAM_TAG = "in-param";

    private BeanDefinition parseQuery(Element queryElement, List<Element> paramElements, ParserContext nestedCtx) {
        if (PARAMETERIZED_QUERY.equals(queryElement.getLocalName())) {
            return this.parseParameterizedQuery(queryElement, paramElements, nestedCtx);
        }
        if (TEMPLATE_QUERY_REF.equals(queryElement.getLocalName())) {
            return this.parseTemplateQueryRef(queryElement, paramElements, nestedCtx);
        }
        if (DYNAMIC_QUERY.equals(queryElement.getLocalName())) {
            return this.parseDynamicQuery(queryElement);
        }
        throw new IllegalStateException("Element must contain an element in: " + Arrays.toString(QUERY_TAG_NAMES));
    }

    private BeanDefinition parseDynamicQuery(Element queryElement) {
        BeanDefinitionBuilder queryTemplateFactory = BeanDefinitionBuilder.genericBeanDefinition(DynamicQueryTemplateFactoryBean.class);
        queryTemplateFactory.addConstructorArgValue((Object)queryElement.getTextContent());
        BeanDefinitionBuilder queryBuilder = BeanDefinitionBuilder.genericBeanDefinition(Query.class);
        queryBuilder.addConstructorArgValue((Object)queryTemplateFactory.getBeanDefinition());
        queryBuilder.addConstructorArgValue(Collections.emptyList());
        return queryBuilder.getBeanDefinition();
    }

    private BeanDefinition parseTemplateQueryRef(Element queryElement, List<Element> paramElements, ParserContext nestedCtx) {
        String queryTemplateRef = queryElement.getAttribute(NAME_ATTRIBUTE);
        List<BeanDefinition> paramValues = QueryDefinitionParser.parseOverriddenTemplateParameters(paramElements, nestedCtx);
        BeanDefinitionBuilder queryTemplateFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(QueryTemplateFactoryBean.class);
        queryTemplateFactoryBean.addConstructorArgReference(queryTemplateRef);
        queryTemplateFactoryBean.addConstructorArgValue(paramValues);
        BeanDefinitionBuilder queryBuilder = BeanDefinitionBuilder.genericBeanDefinition(Query.class);
        queryBuilder.addConstructorArgValue((Object)queryTemplateFactoryBean.getBeanDefinition());
        return queryBuilder.getBeanDefinition();
    }

    private BeanDefinition parseParameterizedQuery(Element queryElement, List<Element> paramElements, ParserContext nestedCtx) {
        List<BeanDefinition> params = this.parseStoreProcedureParams(paramElements, nestedCtx);
        BeanDefinitionBuilder queryTemplateFactory = BeanDefinitionBuilder.genericBeanDefinition(ParameterizedQueryTemplateFactoryBean.class);
        queryTemplateFactory.addConstructorArgValue((Object)queryElement.getTextContent());
        queryTemplateFactory.addConstructorArgValue(params);
        queryTemplateFactory.addConstructorArgValue((Object)new SimpleQueryTemplateParser());
        BeanDefinitionBuilder queryBean = BeanDefinitionBuilder.genericBeanDefinition(Query.class);
        queryBean.addConstructorArgValue((Object)queryTemplateFactory.getBeanDefinition());
        return queryBean.getBeanDefinition();
    }

    private List<BeanDefinition> parseStoreProcedureParams(List<Element> paramElements, ParserContext nestedCtx) {
        ManagedList params = new ManagedList();
        for (Element param : paramElements) {
            AbstractParamDefinitionDefinitionParser paramParser;
            if (IN_PARAM_TAG.equals(param.getLocalName())) {
                paramParser = new InputParamDefinitionDefinitionParser();
            } else if ("out-param".equals(param.getLocalName())) {
                paramParser = new OutputParamDefinitionDefinitionParser();
            } else if ("inout-param".equals(param.getLocalName())) {
                paramParser = new InOutParamDefinitionDefinitionParser();
            } else {
                throw new IllegalStateException("Unsupported param type: " + param.getLocalName());
            }
            BeanDefinition paramBean = paramParser.parse(param, nestedCtx);
            params.add(paramBean);
        }
        return params;
    }

    public static List<BeanDefinition> parseOverriddenTemplateParameters(List<Element> paramElements, ParserContext nestedCtx) {
        ManagedList params = new ManagedList();
        for (Element param : paramElements) {
            if (!IN_PARAM_TAG.equals(param.getLocalName())) {
                throw new IllegalStateException("Unsupported param type: " + param.getLocalName());
            }
            InputParamValueBeanDefinitionParser paramParser = new InputParamValueBeanDefinitionParser();
            BeanDefinition paramBean = paramParser.parse(param, nestedCtx);
            params.add(paramBean);
        }
        return params;
    }

    public BeanDefinition parseQuery(Element element, ParserContext nestedCtx) {
        List childElementsByTagName = DomUtils.getChildElementsByTagName((Element)element, (String[])QUERY_TAG_NAMES);
        if (childElementsByTagName.size() == 0) {
            throw new IllegalArgumentException(String.format("Element %s must contain one of the following elements: %s", element.getTagName(), Arrays.toString(QUERY_TAG_NAMES)));
        }
        List params = DomUtils.getChildElementsByTagName((Element)element, (String[])new String[]{IN_PARAM_TAG, "out-param", "inout-param"});
        Element queryElement = (Element)childElementsByTagName.get(0);
        element.removeChild(queryElement);
        return this.parseQuery(queryElement, params, nestedCtx);
    }
}

