/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.type;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.db.connection.DbConnectionFactory;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.resulthandler.MapRecordHandler;
import org.mule.module.db.sqlexecutor.resulthandler.ResultSetIterator;
import org.mule.module.db.sqlexecutor.resulthandler.StatementStreamingResultSetCloser;
import org.mule.module.db.sqlexecutor.type.AbstractDbType;
import org.mule.module.db.sqlexecutor.type.DbType;
import org.mule.module.db.sqlexecutor.type.DbTypeManager;
import org.mule.module.db.sqlexecutor.type.TypeDoesNotExistsException;
import org.mule.module.db.sqlexecutor.type.UnknownDbType;
import org.mule.module.db.transaction.TransactionalAction;

public class MetadataDbTypeManager
implements DbTypeManager {
    private final Log logger = LogFactory.getLog(MetadataDbTypeManager.class);
    private final Map<String, DbType> typesById = new HashMap<String, DbType>();
    private final DbConnectionFactory dbConnectionFactory;
    private final Object lock = new Object();
    private boolean initialised;

    public MetadataDbTypeManager(DbConnectionFactory dbConnectionFactory) {
        this.dbConnectionFactory = dbConnectionFactory;
    }

    protected void registerType(DbType dbType) {
        String typeKey = dbType.getName() + dbType.getId();
        if (this.typesById.containsKey(typeKey)) {
            throw new IllegalArgumentException(String.format("There is already a registered type with ID %s and name %s", dbType.getId(), dbType.getName()));
        }
        this.typesById.put(typeKey, dbType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbType get(int id, String name) throws TypeDoesNotExistsException {
        String typeKey;
        if (!this.initialised) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.initialised) {
                    this.initialise();
                    this.initialised = true;
                }
            }
        }
        if (this.typesById.containsKey(typeKey = name + id)) {
            return this.typesById.get(typeKey);
        }
        if (id == 1111) {
            return UnknownDbType.getInstance();
        }
        throw new TypeDoesNotExistsException(id, name);
    }

    protected void initialise() {
        DbConnection connection;
        try {
            connection = this.dbConnectionFactory.createConnection(TransactionalAction.NOT_SUPPORTED);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cannot obtain type information form database");
        }
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet typeInfo = metaData.getTypeInfo();
            ResultSetIterator resultSetIterator = new ResultSetIterator(connection, typeInfo, new MapRecordHandler(), new StatementStreamingResultSetCloser());
            while (resultSetIterator.hasNext()) {
                Object typeRecord = resultSetIterator.next();
                Number data_type = (Number)typeRecord.get("DATA_TYPE");
                String type_name = (String)typeRecord.get("TYPE_NAME");
                String literalPrefix = (String)typeRecord.get("LITERAL_PREFIX");
                String literalSuffix = (String)typeRecord.get("LITERAL_SUFFIX");
                this.registerType(new AbstractDbType(data_type.intValue(), type_name, literalPrefix, literalSuffix));
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Type: " + typeRecord));
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cannot process metadata information", e);
        }
        finally {
            this.dbConnectionFactory.releaseConnection(connection);
        }
    }
}

