/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.module.db.config.AbstractParamDefinitionDefinitionParser;
import org.mule.module.db.config.CommandDefinitionFactoryBean;
import org.mule.module.db.config.InOutParamDefinitionDefinitionParser;
import org.mule.module.db.config.InputParamDefinitionDefinitionParser;
import org.mule.module.db.config.InputParamValueBeanDefinitionParser;
import org.mule.module.db.config.NullSqlParamResolverFactoryBean;
import org.mule.module.db.config.OutputParamDefinitionDefinitionParser;
import org.mule.module.db.resolver.ConstantSqlCommandResolver;
import org.mule.module.db.sqlexecutor.command.InputSqlParamValue;
import org.mule.module.db.sqlexecutor.command.SqlCommand;
import org.mule.module.db.sqlexecutor.command.SqlCommandDefinition;
import org.mule.module.db.sqlexecutor.command.SqlCommandType;
import org.mule.module.db.sqlexecutor.param.InputSqlParam;
import org.mule.module.db.sqlexecutor.parser.SimpleSqlCommandParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ParameterizedQueryDefinitionParser {
    public static final String PARAMETERIZED_QUERY = "parameterized-query";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String TEMPLATE_QUERY_REF = "template-query-ref";
    public static final String DYNAMIC_QUERY = "dynamic-query";
    public static final String[] QUERY_TAG_NAMES = new String[]{"parameterized-query", "template-query-ref", "dynamic-query"};
    public static final String IN_PARAM_TAG = "in-param";

    private BeanDefinition parseQuery(Element queryElement, List<Element> paramElements, ParserContext nestedCtx, BeanDefinition sqlParamResolver, BeanDefinition jdbcConfigResolver) {
        if (PARAMETERIZED_QUERY.equals(queryElement.getLocalName())) {
            return this.parseParameterizedQuery(queryElement, paramElements, nestedCtx, sqlParamResolver, jdbcConfigResolver);
        }
        if (TEMPLATE_QUERY_REF.equals(queryElement.getLocalName())) {
            return this.parseTemplateQueryRef(queryElement, paramElements, nestedCtx, sqlParamResolver, jdbcConfigResolver);
        }
        if (DYNAMIC_QUERY.equals(queryElement.getLocalName())) {
            return this.parseDynamicQuery(queryElement, paramElements, nestedCtx, sqlParamResolver, jdbcConfigResolver);
        }
        throw new IllegalStateException("Element must contain an element in: " + Arrays.toString(QUERY_TAG_NAMES));
    }

    private BeanDefinition parseDynamicQuery(Element queryElement, List<Element> paramElements, ParserContext nestedCtx, BeanDefinition sqlParamResolver, BeanDefinition jdbcConfigResolver) {
        List<BeanDefinition> paramValues = ParameterizedQueryDefinitionParser.parseParameterValues(paramElements, nestedCtx);
        String sql = queryElement.getTextContent();
        SqlCommandDefinition sqlCommandDefinition = new SqlCommandDefinition(sql, SqlCommandType.DDL, Collections.EMPTY_LIST, true);
        BeanDefinitionBuilder queryFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(SqlCommand.class);
        queryFactoryBean.addConstructorArgValue((Object)sqlCommandDefinition);
        queryFactoryBean.addConstructorArgValue(paramValues);
        AbstractBeanDefinition sqlCommandBeanDefinition = queryFactoryBean.getBeanDefinition();
        BeanDefinitionBuilder sqlCommandSelectorBean = BeanDefinitionBuilder.genericBeanDefinition(ConstantSqlCommandResolver.class);
        sqlCommandSelectorBean.addConstructorArgValue((Object)sqlCommandBeanDefinition);
        sqlCommandSelectorBean.addConstructorArgValue((Object)sqlParamResolver);
        sqlCommandSelectorBean.addConstructorArgValue((Object)jdbcConfigResolver);
        return sqlCommandSelectorBean.getBeanDefinition();
    }

    private BeanDefinition parseTemplateQueryRef(Element queryElement, List<Element> paramElements, ParserContext nestedCtx, BeanDefinition sqlParamResolver, BeanDefinition jdbcConfigResolver) {
        String commandDefRef = queryElement.getAttribute(NAME_ATTRIBUTE);
        List<BeanDefinition> paramValues = ParameterizedQueryDefinitionParser.parseParameterValues(paramElements, nestedCtx);
        BeanDefinitionBuilder commandDefinitionFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(CommandDefinitionFactoryBean.class);
        commandDefinitionFactoryBean.addConstructorArgReference(commandDefRef);
        commandDefinitionFactoryBean.addConstructorArgValue(paramValues);
        BeanDefinitionBuilder queryFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(SqlCommand.class);
        queryFactoryBean.addConstructorArgValue((Object)commandDefinitionFactoryBean.getBeanDefinition());
        AbstractBeanDefinition sqlCommandBeanDefinition = queryFactoryBean.getBeanDefinition();
        BeanDefinitionBuilder sqlCommandSelectorBean = BeanDefinitionBuilder.genericBeanDefinition(ConstantSqlCommandResolver.class);
        sqlCommandSelectorBean.addConstructorArgValue((Object)sqlCommandBeanDefinition);
        sqlCommandSelectorBean.addConstructorArgValue((Object)sqlParamResolver);
        sqlCommandSelectorBean.addConstructorArgValue((Object)jdbcConfigResolver);
        return sqlCommandSelectorBean.getBeanDefinition();
    }

    private BeanDefinition parseParameterizedQuery(Element queryElement, List<Element> paramElements, ParserContext nestedCtx, BeanDefinition sqlParamResolver, BeanDefinition jdbcConfigResolver) {
        SimpleSqlCommandParser sqlParser = new SimpleSqlCommandParser();
        String sql = queryElement.getTextContent();
        SqlCommandDefinition sqlCommandDefinition = sqlParser.parse(sql);
        if (sqlCommandDefinition.getType() == SqlCommandType.STORE_PROCEDURE_CALL) {
            List<BeanDefinition> newParams = this.parseStoreProcedureParams(paramElements, nestedCtx);
            BeanDefinitionBuilder definitionFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(SqlCommandDefinition.class);
            definitionFactoryBean.addConstructorArgValue((Object)sqlCommandDefinition.getSqlText());
            definitionFactoryBean.addConstructorArgValue((Object)sqlCommandDefinition.getType());
            definitionFactoryBean.addConstructorArgValue(newParams);
            BeanDefinitionBuilder queryFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(SqlCommand.class);
            queryFactoryBean.addConstructorArgValue((Object)definitionFactoryBean.getBeanDefinition());
            AbstractBeanDefinition sqlCommandBeanDefinition = queryFactoryBean.getBeanDefinition();
            BeanDefinitionBuilder sqlCommandSelectorBean = BeanDefinitionBuilder.genericBeanDefinition(ConstantSqlCommandResolver.class);
            sqlCommandSelectorBean.addConstructorArgValue((Object)sqlCommandBeanDefinition);
            sqlCommandSelectorBean.addConstructorArgValue((Object)sqlParamResolver);
            sqlCommandSelectorBean.addConstructorArgValue((Object)jdbcConfigResolver);
            return sqlCommandSelectorBean.getBeanDefinition();
        }
        List<BeanDefinition> params = ParameterizedQueryDefinitionParser.parseParameterValues(paramElements, nestedCtx);
        BeanDefinitionBuilder queryFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(SqlCommand.class);
        queryFactoryBean.addConstructorArgValue((Object)sqlCommandDefinition);
        if (params.size() == 0 && !sqlCommandDefinition.getParams().isEmpty()) {
            ArrayList<InputSqlParamValue> paramValues = new ArrayList<InputSqlParamValue>();
            for (InputSqlParam inputSqlParam : sqlCommandDefinition.getInputParams()) {
                InputSqlParamValue paramValue = new InputSqlParamValue();
                paramValue.setValue(inputSqlParam.getValue());
                paramValue.setName(inputSqlParam.getName());
                paramValues.add(paramValue);
            }
            queryFactoryBean.addConstructorArgValue(paramValues);
        } else {
            queryFactoryBean.addConstructorArgValue(params);
        }
        AbstractBeanDefinition sqlCommandBeanDefinition = queryFactoryBean.getBeanDefinition();
        BeanDefinitionBuilder sqlCommandSelectorBean = BeanDefinitionBuilder.genericBeanDefinition(ConstantSqlCommandResolver.class);
        sqlCommandSelectorBean.addConstructorArgValue((Object)sqlCommandBeanDefinition);
        sqlCommandSelectorBean.addConstructorArgValue((Object)sqlParamResolver);
        sqlCommandSelectorBean.addConstructorArgValue((Object)jdbcConfigResolver);
        return sqlCommandSelectorBean.getBeanDefinition();
    }

    private List<BeanDefinition> parseStoreProcedureParams(List<Element> paramElements, ParserContext nestedCtx) {
        ManagedList params = new ManagedList();
        for (Element param : paramElements) {
            AbstractParamDefinitionDefinitionParser paramParser;
            if (IN_PARAM_TAG.equals(param.getLocalName())) {
                paramParser = new InputParamDefinitionDefinitionParser();
            } else if ("out-param".equals(param.getLocalName())) {
                paramParser = new OutputParamDefinitionDefinitionParser();
            } else if ("inout-param".equals(param.getLocalName())) {
                paramParser = new InOutParamDefinitionDefinitionParser();
            } else {
                throw new IllegalStateException("Unsupported param type: " + param.getLocalName());
            }
            BeanDefinition paramBean = paramParser.parse(param, nestedCtx);
            params.add(paramBean);
        }
        return params;
    }

    public static List<BeanDefinition> parseParameterValues(List<Element> paramElements, ParserContext nestedCtx) {
        ManagedList params = new ManagedList();
        for (Element param : paramElements) {
            if (!IN_PARAM_TAG.equals(param.getLocalName())) {
                throw new IllegalStateException("Unsupported param type: " + param.getLocalName());
            }
            InputParamValueBeanDefinitionParser paramParser = new InputParamValueBeanDefinitionParser();
            BeanDefinition paramBean = paramParser.parse(param, nestedCtx);
            params.add(paramBean);
        }
        return params;
    }

    public BeanDefinition parseOptionalQuery(Element element, ParserContext nestedCtx, BeanDefinition jdbcConfigResolver) {
        BeanDefinition result = null;
        if (!DomUtils.getChildElementsByTagName((Element)element, (String[])QUERY_TAG_NAMES).isEmpty()) {
            BeanDefinitionBuilder sqlParamResolverFactory = BeanDefinitionBuilder.genericBeanDefinition(NullSqlParamResolverFactoryBean.class);
            AbstractBeanDefinition sqlParamResolver = sqlParamResolverFactory.getBeanDefinition();
            result = this.parseQuery(element, nestedCtx, (BeanDefinition)sqlParamResolver, jdbcConfigResolver);
        }
        return result;
    }

    public BeanDefinition parseQuery(Element element, ParserContext nestedCtx, BeanDefinition sqlParamResolver, BeanDefinition jdbcConfigResolver) {
        List childElementsByTagName = DomUtils.getChildElementsByTagName((Element)element, (String[])QUERY_TAG_NAMES);
        if (childElementsByTagName.size() == 0) {
            throw new IllegalArgumentException(String.format("Element %s must contain one of the following elements: %s", element.getTagName(), Arrays.toString(QUERY_TAG_NAMES)));
        }
        List params = DomUtils.getChildElementsByTagName((Element)element, (String[])new String[]{IN_PARAM_TAG, "out-param", "inout-param"});
        Element queryElement = (Element)childElementsByTagName.get(0);
        element.removeChild(queryElement);
        return this.parseQuery(queryElement, params, nestedCtx, sqlParamResolver, jdbcConfigResolver);
    }
}

