/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.executor;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.mule.module.db.sqlexecutor.command.SqlCommand;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.executor.AbstractExecutor;
import org.mule.module.db.sqlexecutor.executor.AutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.ColumnIndexAutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.ColumnNameAutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.DefaultAutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.NoAutoGeneratedKey;
import org.mule.module.db.sqlexecutor.resulthandler.StatementResultHandler;
import org.mule.module.db.sqlexecutor.statement.SqlStatementFactory;

public class SqlExecutor
extends AbstractExecutor {
    private final StatementResultHandler statementResultHandler;

    public SqlExecutor(SqlStatementFactory statementFactory, StatementResultHandler statementResultHandler) {
        super(statementFactory);
        this.statementResultHandler = statementResultHandler;
    }

    @Override
    protected Object executeSqlCommand(DbConnection connection, Statement statement, SqlCommand sqlCommand) throws SQLException {
        return this.executeSqlCommand(null, statement, sqlCommand, new NoAutoGeneratedKey());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object executeSqlCommand(DbConnection connection, Statement statement, SqlCommand sqlCommand, AutoGeneratedKey autoGeneratedKey) throws SQLException {
        if (autoGeneratedKey.retrieveAutoGeneratedKeys()) {
            if (statement instanceof PreparedStatement) {
                this.doProcessParameters((PreparedStatement)statement, sqlCommand.getSqlCommandDefinition().getParams(), sqlCommand.getParamValues());
                ((PreparedStatement)statement).execute();
                return this.statementResultHandler.processStatement(connection, statement, sqlCommand.getSqlCommandDefinition(), autoGeneratedKey);
            } else if (autoGeneratedKey instanceof ColumnIndexAutoGeneratedKey) {
                statement.executeUpdate(sqlCommand.getSqlCommandDefinition().getSqlText(), ((ColumnIndexAutoGeneratedKey)autoGeneratedKey).getColumnIndexes());
                return this.statementResultHandler.processStatement(connection, statement, sqlCommand.getSqlCommandDefinition(), autoGeneratedKey);
            } else if (autoGeneratedKey instanceof DefaultAutoGeneratedKey) {
                statement.execute(sqlCommand.getSqlCommandDefinition().getSqlText(), 1);
                return this.statementResultHandler.processStatement(connection, statement, sqlCommand.getSqlCommandDefinition(), autoGeneratedKey);
            } else {
                if (!(autoGeneratedKey instanceof ColumnNameAutoGeneratedKey)) throw new IllegalArgumentException("Not supported auto generated key: " + autoGeneratedKey.getClass().getName());
                statement.executeUpdate(sqlCommand.getSqlCommandDefinition().getSqlText(), ((ColumnNameAutoGeneratedKey)autoGeneratedKey).getColumnNames());
            }
            return this.statementResultHandler.processStatement(connection, statement, sqlCommand.getSqlCommandDefinition(), autoGeneratedKey);
        } else if (statement instanceof PreparedStatement) {
            this.doProcessParameters((PreparedStatement)statement, sqlCommand.getSqlCommandDefinition().getParams(), sqlCommand.getParamValues());
            ((PreparedStatement)statement).execute();
            return this.statementResultHandler.processStatement(connection, statement, sqlCommand.getSqlCommandDefinition(), autoGeneratedKey);
        } else {
            statement.execute(sqlCommand.getSqlCommandDefinition().getSqlText(), 2);
        }
        return this.statementResultHandler.processStatement(connection, statement, sqlCommand.getSqlCommandDefinition(), autoGeneratedKey);
    }
}

