/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.connection;

import java.util.Collection;
import org.mule.api.MuleEvent;
import org.mule.api.registry.MuleRegistry;
import org.mule.module.db.sqlexecutor.connection.DbConfig;
import org.mule.module.db.sqlexecutor.connection.DbConfigResolver;

public class DefaultDbConfigResolver
implements DbConfigResolver {
    private MuleRegistry registry;

    public DefaultDbConfigResolver(MuleRegistry registry) {
        this.registry = registry;
    }

    @Override
    public DbConfig resolve(MuleEvent muleEvent) {
        Collection dbConfigs = this.registry.lookupObjects(DbConfig.class);
        if (dbConfigs.size() == 0) {
            throw new IllegalStateException("There is no database config defined");
        }
        if (dbConfigs.size() > 1) {
            StringBuilder buf = new StringBuilder();
            for (DbConfig dbConfig : dbConfigs) {
                if (buf.length() != 0) {
                    buf.append(", ");
                }
                buf.append(dbConfig.getName());
            }
            throw new IllegalStateException("Database config must be explicitly defined using 'config-ref' attribute there are multiple database configs defined: " + buf);
        }
        return (DbConfig)dbConfigs.iterator().next();
    }
}

