/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.config.database;

import java.net.URI;
import java.net.URISyntaxException;
import org.mule.module.db.config.database.DbConfigFactoryBean;
import org.mule.util.StringUtils;

public class MySqlConfigFactoryBean
extends DbConfigFactoryBean {
    private static final String DRIVER_CLASS_NAME = "com.mysql.jdbc.Driver";
    private static final String JDBC_URL_PREFIX = "jdbc:mysql://";
    private String database;
    private String host;
    private int port = -1;

    public MySqlConfigFactoryBean() {
        this.setDriverClassName(DRIVER_CLASS_NAME);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    protected String getEffectiveUrl() {
        String url = this.getUrl();
        if (StringUtils.isEmpty((String)url)) {
            StringBuilder buf = new StringBuilder(128);
            buf.append(this.getUrlPrefix());
            buf.append(this.getHost());
            if (this.getPort() > 0) {
                buf.append(":");
                buf.append(this.getPort());
            }
            buf.append("/");
            buf.append(this.getDatabase());
            url = buf.toString();
        }
        if (DRIVER_CLASS_NAME.equals(this.getDriverClassName())) {
            url = this.forceParamMetadataGeneration(url);
        }
        return url;
    }

    private String forceParamMetadataGeneration(String url) {
        StringBuilder buf = new StringBuilder(128);
        buf.append(url);
        try {
            URI uri = new URI(url.substring(5));
            String query = uri.getQuery();
            if (query == null) {
                buf.append("?");
            } else {
                buf.append("&");
            }
            buf.append("generateSimpleParameterMetadata=true");
            url = buf.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to parse database config's URL", e);
        }
        return url;
    }

    public String getUrlPrefix() {
        return JDBC_URL_PREFIX;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }
}

