/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.OneWayProcessorInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.mule.AbstractAnnotatedObject;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.service.ServiceAware;
import org.mule.module.cxf.CxfConfiguration;
import org.mule.module.cxf.CxfInboundMessageProcessor;
import org.mule.module.cxf.MuleInvoker;
import org.mule.module.cxf.config.WsSecurity;
import org.mule.module.cxf.support.CxfUtils;
import org.mule.module.cxf.support.MuleHeadersInInterceptor;
import org.mule.module.cxf.support.MuleHeadersOutInterceptor;
import org.mule.module.cxf.support.MuleServiceConfiguration;
import org.mule.module.cxf.support.WSDLQueryHandler;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public abstract class AbstractInboundMessageProcessorBuilder
extends AbstractAnnotatedObject
implements MuleContextAware,
MessageProcessorBuilder {
    private CxfConfiguration configuration;
    private Server server;
    private boolean enableMuleSoapHeaders = true;
    private String wsdlLocation;
    private String bindingId;
    private String mtomEnabled;
    private String soapVersion;
    private String service;
    private String namespace;
    private List<AbstractFeature> features;
    private List<Interceptor<? extends Message>> inInterceptors = new CopyOnWriteArrayList<Interceptor<? extends Message>>();
    private List<Interceptor<? extends Message>> inFaultInterceptors = new CopyOnWriteArrayList<Interceptor<? extends Message>>();
    private List<Interceptor<? extends Message>> outInterceptors = new CopyOnWriteArrayList<Interceptor<? extends Message>>();
    private List<Interceptor<? extends Message>> outFaultInterceptors = new CopyOnWriteArrayList<Interceptor<? extends Message>>();
    protected MuleContext muleContext;
    private String port;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private boolean validationEnabled;
    private List<String> schemaLocations;
    private WsSecurity wsSecurity;

    public CxfInboundMessageProcessor build() throws MuleException {
        ServerFactoryBean sfb;
        if (this.muleContext == null) {
            throw new IllegalStateException("MuleContext must be supplied.");
        }
        if (this.configuration == null) {
            this.configuration = CxfConfiguration.getConfiguration(this.muleContext);
        }
        if (this.configuration == null) {
            throw new IllegalStateException("A CxfConfiguration object must be supplied.");
        }
        try {
            sfb = this.createServerFactory();
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
        if (this.bindingId != null) {
            sfb.setBindingId(this.bindingId);
        }
        if (this.features != null) {
            sfb.getFeatures().addAll(this.features);
        }
        if (this.mtomEnabled != null) {
            this.properties.put("mtom-enabled", this.mtomEnabled);
            this.properties.put("write.attachments", true);
        }
        if (this.inInterceptors != null) {
            sfb.getInInterceptors().addAll(this.inInterceptors);
        }
        if (this.inFaultInterceptors != null) {
            sfb.getInFaultInterceptors().addAll(this.inFaultInterceptors);
        }
        if (this.outInterceptors != null) {
            sfb.getOutInterceptors().addAll(this.outInterceptors);
        }
        if (this.outFaultInterceptors != null) {
            sfb.getOutFaultInterceptors().addAll(this.outFaultInterceptors);
        }
        if (this.enableMuleSoapHeaders && !this.configuration.isEnableMuleSoapHeaders()) {
            sfb.getInInterceptors().add(new MuleHeadersInInterceptor());
            sfb.getInFaultInterceptors().add(new MuleHeadersInInterceptor());
            sfb.getOutInterceptors().add(new MuleHeadersOutInterceptor());
            sfb.getOutFaultInterceptors().add(new MuleHeadersOutInterceptor());
        }
        this.setSecurityConfig(sfb);
        String address = this.getAddress();
        address = CxfUtils.mapUnsupportedSchemas(address);
        sfb.setAddress(address);
        if (this.wsdlLocation != null) {
            sfb.setWsdlURL(this.wsdlLocation);
        }
        sfb.setSchemaLocations(this.schemaLocations);
        ReflectionServiceFactoryBean svcFac = sfb.getServiceFactory();
        this.initServiceFactory(svcFac);
        CxfInboundMessageProcessor processor = new CxfInboundMessageProcessor();
        processor.setMuleContext(this.muleContext);
        this.configureMessageProcessor(sfb, processor);
        sfb.setStart(false);
        Bus bus = this.configuration.getCxfBus();
        sfb.setBus(bus);
        svcFac.setBus(bus);
        Configurer configurer = (Configurer)bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(svcFac.getEndpointName().toString(), (Object)sfb);
        }
        if (this.validationEnabled) {
            this.properties.put("schema-validation-enabled", "true");
        }
        if (this.soapVersion != null) {
            sfb.setBindingId(CxfUtils.getBindingIdForSoapVersion(this.soapVersion));
        }
        sfb.setProperties(this.properties);
        sfb.setInvoker(this.createInvoker(processor));
        this.server = sfb.create();
        CxfUtils.removeInterceptor(this.server.getEndpoint().getService().getInInterceptors(), OneWayProcessorInterceptor.class.getName());
        this.configureServer(this.server);
        processor.setBus(sfb.getBus());
        processor.setServer(this.server);
        processor.setProxy(this.isProxy());
        processor.setWSDLQueryHandler(this.getWSDLQueryHandler());
        return processor;
    }

    protected QueryHandler getWSDLQueryHandler() {
        return new WSDLQueryHandler(this.configuration.getCxfBus());
    }

    protected Invoker createInvoker(CxfInboundMessageProcessor processor) {
        return new MuleInvoker(processor, this.getServiceClass());
    }

    protected void configureServer(Server server2) {
    }

    protected abstract Class<?> getServiceClass();

    protected void configureMessageProcessor(ServerFactoryBean sfb, CxfInboundMessageProcessor processor) {
    }

    protected abstract ServerFactoryBean createServerFactory() throws Exception;

    protected String getAddress() {
        return "http://internalMuleCxfRegistry/" + ((Object)((Object)this)).hashCode();
    }

    private void initServiceFactory(ReflectionServiceFactoryBean svcFac) {
        this.addIgnoredMethods(svcFac, Callable.class.getName());
        this.addIgnoredMethods(svcFac, Initialisable.class.getName());
        this.addIgnoredMethods(svcFac, Disposable.class.getName());
        this.addIgnoredMethods(svcFac, ServiceAware.class.getName());
        svcFac.getServiceConfigurations().add(0, new MuleServiceConfiguration(this));
        svcFac.setServiceClass(this.getServiceClass());
        for (AbstractServiceConfiguration c : svcFac.getServiceConfigurations()) {
            c.setServiceFactory(svcFac);
        }
    }

    public void addIgnoredMethods(ReflectionServiceFactoryBean svcFac, String className) {
        try {
            Class c = ClassUtils.loadClass((String)className, ((Object)((Object)this)).getClass());
            for (int i = 0; i < c.getMethods().length; ++i) {
                svcFac.getIgnoredMethods().add(c.getMethods()[i]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void setSecurityConfig(ServerFactoryBean sfb) {
        if (this.wsSecurity != null) {
            if (this.wsSecurity.getCustomValidator() != null && !this.wsSecurity.getCustomValidator().isEmpty()) {
                for (Map.Entry<String, Object> entry : this.wsSecurity.getCustomValidator().entrySet()) {
                    this.properties.put(entry.getKey(), entry.getValue());
                }
            }
            if (this.wsSecurity.getSecurityManager() != null) {
                this.properties.put("ws-security.ut.validator", this.wsSecurity.getSecurityManager());
            }
            if (this.wsSecurity.getConfigProperties() != null && !this.wsSecurity.getConfigProperties().isEmpty()) {
                sfb.getInInterceptors().add(new WSS4JInInterceptor(this.wsSecurity.getConfigProperties()));
                String actionProperty = (String)this.wsSecurity.getConfigProperties().get("action");
                if (!StringUtils.isEmpty((String)actionProperty) && actionProperty.contains("SAMLTokenUnsigned")) {
                    this.properties.put("ws-security.validate.saml.subject.conf", false);
                }
            }
        }
    }

    public Server getServer() {
        return this.server;
    }

    public abstract boolean isProxy();

    public CxfConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CxfConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isEnableMuleSoapHeaders() {
        return this.enableMuleSoapHeaders;
    }

    public void setEnableMuleSoapHeaders(boolean enableMuleSoapHeaders) {
        this.enableMuleSoapHeaders = enableMuleSoapHeaders;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlUrl) {
        this.wsdlLocation = wsdlUrl;
    }

    public String getBindingId() {
        return this.bindingId;
    }

    public void setBindingId(String bindingId) {
        this.bindingId = bindingId;
    }

    public void setSoapVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    public String getSoapVersion() {
        return this.soapVersion;
    }

    public String getMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomEnabled(String mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String name) {
        this.service = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public List<AbstractFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<AbstractFeature> features) {
        this.features = features;
    }

    public List<Interceptor<? extends Message>> getInInterceptors() {
        return this.inInterceptors;
    }

    public void setInInterceptors(List<Interceptor<? extends Message>> inInterceptors) {
        this.inInterceptors = inInterceptors;
    }

    public List<Interceptor<? extends Message>> getInFaultInterceptors() {
        return this.inFaultInterceptors;
    }

    public void setInFaultInterceptors(List<Interceptor<? extends Message>> inFaultInterceptors) {
        this.inFaultInterceptors = inFaultInterceptors;
    }

    public List<Interceptor<? extends Message>> getOutInterceptors() {
        return this.outInterceptors;
    }

    public void setOutInterceptors(List<Interceptor<? extends Message>> outInterceptors) {
        this.outInterceptors = outInterceptors;
    }

    public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
        return this.outFaultInterceptors;
    }

    public void setOutFaultInterceptors(List<Interceptor<? extends Message>> outFaultInterceptors) {
        this.outFaultInterceptors = outFaultInterceptors;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String endpoint) {
        this.port = endpoint;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setAddProperties(Map<String, Object> properties) {
        this.properties.putAll(properties);
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    public List<String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public void setSchemaLocations(List<String> schemaLocations) {
        this.schemaLocations = schemaLocations;
    }

    public void setWsSecurity(WsSecurity wsSecurity) {
        this.wsSecurity = wsSecurity;
    }
}

