/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.builder;

import org.apache.cxf.binding.soap.interceptor.RPCOutInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapOutInterceptor;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.stax.StaxDataBinding;
import org.apache.cxf.databinding.stax.StaxDataBindingFeature;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.BareOutInterceptor;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.model.ServiceInfo;
import org.mule.module.cxf.builder.AbstractInboundMessageProcessorBuilder;
import org.mule.module.cxf.support.CopyAttachmentInInterceptor;
import org.mule.module.cxf.support.CopyAttachmentOutInterceptor;
import org.mule.module.cxf.support.CxfUtils;
import org.mule.module.cxf.support.OutputPayloadInterceptor;
import org.mule.module.cxf.support.ProxySchemaValidationInInterceptor;
import org.mule.module.cxf.support.ProxyService;
import org.mule.module.cxf.support.ProxyServiceFactoryBean;
import org.mule.module.cxf.support.ResetStaxInterceptor;
import org.mule.module.cxf.support.ReversibleStaxInInterceptor;
import org.mule.module.cxf.support.ReversibleValidatingInterceptor;

public class ProxyServiceMessageProcessorBuilder
extends AbstractInboundMessageProcessorBuilder {
    private String payload;

    @Override
    protected ServerFactoryBean createServerFactory() throws Exception {
        ServerFactoryBean sfb = new ServerFactoryBean();
        sfb.setDataBinding((DataBinding)new StaxDataBinding());
        sfb.getFeatures().add(new StaxDataBindingFeature());
        sfb.setServiceFactory((ReflectionServiceFactoryBean)new ProxyServiceFactoryBean());
        sfb.setServiceClass(ProxyService.class);
        this.addProxyInterceptors(sfb);
        return sfb;
    }

    @Override
    protected Class<?> getServiceClass() {
        return ProxyService.class;
    }

    @Override
    protected void configureServer(Server server) {
        if (this.isProxyEnvelope()) {
            CxfUtils.removeInterceptor(server.getEndpoint().getBinding().getOutInterceptors(), SoapOutInterceptor.class.getName());
        }
        if (CxfUtils.removeInterceptor(server.getEndpoint().getBinding().getOutInterceptors(), RPCOutInterceptor.class.getName())) {
            server.getEndpoint().getBinding().getOutInterceptors().add(new BareOutInterceptor());
        }
        if (this.isValidationEnabled()) {
            server.getEndpoint().getInInterceptors().add(new ProxySchemaValidationInInterceptor(this.getConfiguration().getCxfBus(), (ServiceInfo)server.getEndpoint().getService().getServiceInfos().get(0)));
        }
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    protected void addProxyInterceptors(ServerFactoryBean sfb) {
        sfb.getOutInterceptors().add(new OutputPayloadInterceptor());
        sfb.getInInterceptors().add(new CopyAttachmentInInterceptor());
        sfb.getOutInterceptors().add(new CopyAttachmentOutInterceptor());
        if (this.isProxyEnvelope()) {
            sfb.getInInterceptors().add(new ReversibleStaxInInterceptor());
            sfb.getInInterceptors().add(new ResetStaxInterceptor());
        } else if (this.isValidationEnabled()) {
            sfb.getInInterceptors().add(new ReversibleValidatingInterceptor());
            sfb.getInInterceptors().add(new ResetStaxInterceptor());
        }
    }

    public boolean isProxyEnvelope() {
        return "envelope".equals(this.payload);
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }
}

