/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.builder;

import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.interceptor.CheckFaultInterceptor;
import org.apache.cxf.binding.soap.interceptor.Soap11FaultInInterceptor;
import org.apache.cxf.binding.soap.interceptor.Soap12FaultInInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapOutInterceptor;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.stax.StaxDataBinding;
import org.apache.cxf.databinding.stax.StaxDataBindingFeature;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.interceptor.WrappedOutInterceptor;
import org.mule.api.lifecycle.CreateException;
import org.mule.module.cxf.CxfOutboundMessageProcessor;
import org.mule.module.cxf.builder.AbstractOutboundMessageProcessorBuilder;
import org.mule.module.cxf.support.CopyAttachmentInInterceptor;
import org.mule.module.cxf.support.CopyAttachmentOutInterceptor;
import org.mule.module.cxf.support.CxfUtils;
import org.mule.module.cxf.support.OutputPayloadInterceptor;
import org.mule.module.cxf.support.ProxyService;
import org.mule.module.cxf.support.ResetStaxInterceptor;
import org.mule.module.cxf.support.ReversibleStaxInInterceptor;
import org.mule.module.cxf.support.StreamClosingInterceptor;
import org.mule.module.cxf.transport.MuleUniversalConduit;

public class ProxyClientMessageProcessorBuilder
extends AbstractOutboundMessageProcessorBuilder {
    private String payload;

    @Override
    protected void configureClient(Client client) {
        MuleUniversalConduit conduit = (MuleUniversalConduit)client.getConduit();
        client.getInInterceptors().add(new CopyAttachmentInInterceptor());
        client.getInInterceptors().add(new StreamClosingInterceptor());
        client.getOutInterceptors().add(new OutputPayloadInterceptor());
        client.getOutInterceptors().add(new CopyAttachmentOutInterceptor());
        conduit.setCloseInput(false);
    }

    public boolean isProxyEnvelope() {
        return "envelope".equals(this.payload);
    }

    @Override
    protected void configureMessageProcessor(CxfOutboundMessageProcessor processor) {
        processor.setProxy(true);
    }

    @Override
    protected Client createClient() throws CreateException, Exception {
        ClientProxyFactoryBean cpf = new ClientProxyFactoryBean();
        cpf.setServiceClass(ProxyService.class);
        cpf.setDataBinding((DataBinding)new StaxDataBinding());
        cpf.getFeatures().add(new StaxDataBindingFeature());
        cpf.setAddress(this.getAddress());
        cpf.setBus(this.getBus());
        cpf.setProperties(this.properties);
        if (this.soapVersion != null) {
            cpf.setBindingId(CxfUtils.getBindingIdForSoapVersion(this.soapVersion));
        }
        if (this.wsdlLocation != null) {
            cpf.setWsdlLocation(this.wsdlLocation);
        }
        Client client = ClientProxy.getClient((Object)cpf.create());
        Binding binding = client.getEndpoint().getBinding();
        CxfUtils.removeInterceptor(binding.getOutInterceptors(), WrappedOutInterceptor.class.getName());
        CxfUtils.removeInterceptor(binding.getInInterceptors(), Soap11FaultInInterceptor.class.getName());
        CxfUtils.removeInterceptor(binding.getInInterceptors(), Soap12FaultInInterceptor.class.getName());
        CxfUtils.removeInterceptor(binding.getInInterceptors(), CheckFaultInterceptor.class.getName());
        if (this.isProxyEnvelope()) {
            CxfUtils.removeInterceptor(binding.getOutInterceptors(), SoapOutInterceptor.class.getName());
            client.getInInterceptors().add(new ReversibleStaxInInterceptor());
            client.getInInterceptors().add(new ResetStaxInterceptor());
        }
        return client;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }
}

