/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.util.ASMHelper;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.cxf.support.MuleHeadersInInterceptor;
import org.mule.module.cxf.support.MuleHeadersOutInterceptor;
import org.mule.module.cxf.support.MuleProtocolHeadersOutInterceptor;
import org.mule.module.cxf.transport.MuleUniversalTransport;
import org.springframework.context.ApplicationContext;

public class CxfConfiguration
implements Initialisable,
Disposable,
MuleContextAware {
    public static final String CXF = "cxf";
    public static final String CONFIGURATION_LOCATION = "configurationLocation";
    public static final String DEFAULT_MULE_NAMESPACE_URI = "http://www.muleumo.org";
    public static final String BUS_PROPERTY = "cxf";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private Bus bus;
    private String configurationLocation;
    private boolean initializeStaticBusInstance;
    private MuleContext muleContext;
    private boolean enableMuleSoapHeaders = true;

    public void initialise() throws InitialisationException {
        BusFactory.setDefaultBus(null);
        ApplicationContext context = (ApplicationContext)this.muleContext.getRegistry().lookupObject("springApplicationContext");
        this.bus = this.configurationLocation != null ? new SpringBusFactory(context).createBus(this.configurationLocation, true) : new SpringBusFactory().createBus((String)null, true);
        if (!this.initializeStaticBusInstance) {
            BusFactory.setDefaultBus(null);
        }
        MuleUniversalTransport transport = new MuleUniversalTransport(this);
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        dfm.registerDestinationFactory("http://schemas.xmlsoap.org/soap/http", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap/http", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/http/configuration", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/http/", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://www.w3.org/2003/05/soap/bindings/HTTP/", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/jms", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/http", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://mule.codehaus.org/cxf", (DestinationFactory)transport);
        ConduitInitiatorManager extension = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        try {
            extension.getConduitInitiator("http://schemas.xmlsoap.org/soap/http");
        }
        catch (BusException e1) {
            // empty catch block
        }
        extension.registerConduitInitiator("http://cxf.apache.org/transports/http", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/wsdl/soap/", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/soap/http", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/soap/http/", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/wsdl/soap/http", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/wsdl/http/", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://www.w3.org/2003/05/soap/bindings/HTTP/", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://cxf.apache.org/transports/http/configuration", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://cxf.apache.org/bindings/xformat", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://cxf.apache.org/transports/jms", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://mule.codehaus.org/cxf", (ConduitInitiator)transport);
        this.bus.getOutInterceptors().add(new MuleProtocolHeadersOutInterceptor());
        this.bus.getOutFaultInterceptors().add(new MuleProtocolHeadersOutInterceptor());
        if (this.enableMuleSoapHeaders) {
            this.bus.getInInterceptors().add(new MuleHeadersInInterceptor());
            this.bus.getInFaultInterceptors().add(new MuleHeadersInInterceptor());
            this.bus.getOutInterceptors().add(new MuleHeadersOutInterceptor());
            this.bus.getOutFaultInterceptors().add(new MuleHeadersOutInterceptor());
        }
    }

    public void dispose() {
        this.bus.shutdown(true);
        JAXBDataBinding.clearCaches();
        try {
            Field cacheField = ASMHelper.class.getDeclaredField("LOADER_MAP");
            cacheField.setAccessible(true);
            Map cache = (Map)cacheField.get(null);
            cache.clear();
        }
        catch (Throwable t) {
            this.logger.warn((Object)"Error disposing CxfConfiguration, this may cause a memory leak", t);
        }
    }

    public Bus getCxfBus() {
        return this.bus;
    }

    public void setCxfBus(Bus bus) {
        this.bus = bus;
    }

    public String getConfigurationLocation() {
        return this.configurationLocation;
    }

    public void setConfigurationLocation(String configurationLocation) {
        this.configurationLocation = configurationLocation;
    }

    public boolean isInitializeStaticBusInstance() {
        return this.initializeStaticBusInstance;
    }

    public void setInitializeStaticBusInstance(boolean initializeStaticBusInstance) {
        this.initializeStaticBusInstance = initializeStaticBusInstance;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public static CxfConfiguration getConfiguration(MuleContext muleContext) throws MuleException {
        CxfConfiguration configuration = (CxfConfiguration)muleContext.getRegistry().get("_cxfConfiguration");
        if (configuration == null) {
            configuration = new CxfConfiguration();
            configuration.setMuleContext(muleContext);
            configuration.initialise();
            muleContext.getRegistry().registerObject("_cxfConfiguration", (Object)configuration);
        }
        return configuration;
    }

    public boolean isEnableMuleSoapHeaders() {
        return this.enableMuleSoapHeaders;
    }

    public void setEnableMuleSoapHeaders(boolean enableMuleSoapHeaders) {
        this.enableMuleSoapHeaders = enableMuleSoapHeaders;
    }
}

