/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.endpoint;

import java.util.Arrays;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.endpoint.AbstractMetaEndpointBuilder;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.module.cxf.builder.WsdlClientMessageProcessorBuilder;
import org.mule.module.cxf.config.FlowConfiguringMessageProcessor;

public class WsdlCxfEndpointBuilder
extends AbstractMetaEndpointBuilder {
    private final String wsdlAddress;

    public WsdlCxfEndpointBuilder(EndpointURIEndpointBuilder global) throws EndpointException {
        super(global);
        this.wsdlAddress = WsdlCxfEndpointBuilder.getEndpointAddressWithoutMetaScheme((String)global.getEndpointBuilder().toString());
        this.uriBuilder = new EndpointURIEndpointBuilder(this.wsdlAddress, this.muleContext).getEndpointBuilder();
    }

    public WsdlCxfEndpointBuilder(String address, MuleContext muleContext) {
        super(WsdlCxfEndpointBuilder.getAddressWithoutQuery(WsdlCxfEndpointBuilder.getEndpointAddressWithoutMetaScheme((String)address)), muleContext);
        this.wsdlAddress = WsdlCxfEndpointBuilder.getEndpointAddressWithoutMetaScheme((String)address);
    }

    public InboundEndpoint buildInboundEndpoint() throws EndpointException, InitialisationException {
        throw new UnsupportedOperationException("Inbound meta CXF endpoints not supported");
    }

    public OutboundEndpoint buildOutboundEndpoint() throws EndpointException, InitialisationException {
        WsdlClientMessageProcessorBuilder builder = new WsdlClientMessageProcessorBuilder();
        builder.setMuleContext(this.muleContext);
        builder.setWsdlLocation(this.wsdlAddress);
        builder.setOperation(this.getOperation());
        try {
            this.messageProcessors = Arrays.asList(new FlowConfiguringMessageProcessor(builder));
        }
        catch (Exception e) {
            throw new EndpointException((Throwable)e);
        }
        return super.buildOutboundEndpoint();
    }

    private String getOperation() {
        String[] params;
        String query = this.wsdlAddress;
        int idx = this.wsdlAddress.lastIndexOf(63);
        if (idx == -1) {
            return null;
        }
        query = this.wsdlAddress.substring(idx + 1);
        for (String p : params = query.split("&")) {
            if (!p.startsWith("method=")) continue;
            return p.substring(7);
        }
        return null;
    }

    private static String getAddressWithoutQuery(String string) {
        int idx = string.indexOf(63);
        if (idx != -1) {
            string = string.substring(0, idx);
        }
        return string;
    }
}

